SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _id_plano_ct varchar;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                tp_org = 'VND' and
                id_org = old.id_vnd and
                id_org_item = old.id_vnd_parc;
                -- org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
            
            delete from tb_mov_bnc
            where 
                id_emp = old.id_emp and
                tp_org = 'VND' and
                id_org = old.id_vnd and
                id_org_item = old.id_vnd_parc;
                -- org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _vnd
            from tb_vnd
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                
                
            select tb_nat_op.* into _nat_op
            from tb_vnd
            join tb_nat_op on
                (tb_vnd.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_vnd.id_emp = new.id_emp and
                tb_vnd.id_vnd = new.id_vnd;
                    
            _gera_fin := _nat_op.op like '%[VND__GER_FIN]%';
            
            
            _id_plano_ct := fc_get_emp_cnf(new.id_emp, 16100 + _op_fnc.id_op_fnc);
                
            if (_id_plano_ct = '') then
                _id_plano_ct := null;
            end if;
            
            if (_nat_op.id_plano_ct is not null) then
                _id_plano_ct := _nat_op.id_plano_ct;
            end if;
            

            if (_op_fnc.gera_ct and _gera_fin) then
                    
                _nr_doc := new.nr_doc;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, tp_org, id_org, id_org_item,
                     id_op_fnc, vl_quit, vl_rest, 
                     obs,
                     id_plano_ct, id_cnt_cst,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_veic)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, 'VND', new.id_vnd, new.id_vnd_parc,
                     new.id_op_fnc, 0, new.vl_parc, 
                     'VENDA ' || new.id_vnd,
                     _id_plano_ct, _nat_op.id_cnt_cst,
                     new.vl_sub_tot, coalesce(new.vl_perc_desc, 0), coalesce(new.vl_desc, 0), coalesce(new.vl_perc_acr, 0), coalesce(new.vl_acr, 0), 
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     _vnd.id_veic);
                
                
                if (_op_fnc.tp_op_fnc = 'BLT') then
                    select * into _ct
                    from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_ct = _id_ct;
                        
                    new.nr_doc := _ct.nr_doc;
                    
--                    raise notice '12345 Boleto %', new.nr_doc;
                    
                elsif (_op_fnc.tp_op_fnc = 'DUP') then
                    new.nr_doc := cast(_id_ct as varchar);
                    
--                    raise notice '12345 Duplicata %', new.nr_doc;
                    
                end if;
            end if;
                
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, tp_org, id_org, id_org_item,
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, 'VND', new.id_vnd, new.id_vnd_parc,
                     _vnd.id_cli, 'PEND',
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     _id_plano_ct,
                     new.id_op_fnc);
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _id_cli_cons varchar;
    
    _list refcursor;
    _item record;
    
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
        
        if (new.id_sit_vnd is not null and new.cd_ref is not null) then
            perform fc_vnd_ident_sit(new.id_emp, cast(new.cd_ref as integer), new.id_sit_vnd);
        end if;
        
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            tp_org = 'VND' and
            id_org = old.id_vnd;
            -- org like 'VND.' || old.id_vnd || '%';
    
    end if;
    
    
    --
    -- Venda cancelada ( mesmo se vier do neo UNI )
    --
    if (tg_op = 'UPDATE' and new.canc = true and new.canc <> old.canc) then
        --
        -- extorna o estoque
        --
        open _list for
            select *
            from tb_vnd_item
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd and
                mov_estq;

        fetch _list into _item;
                
            
        while found loop
                
            perform fc_item_estq(_item.id_item, _item.id_emp, _item.id_dep, _item.id_grd_estq, 'E', _item.vl_qtd_mov);
                
            fetch _list into _item;
                
        end loop;
            
        close _list;
            
        --
        -- extorna contas a receber
        --
        open _list for 
            select *
            from tb_vnd_parc
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                    
        fetch _list into _item;
            
        while found loop
                
            delete from tb_ct
            where 
                id_emp = new.id_emp and
                tp_org = 'VND' and
                id_org = new.id_vnd and
                id_org_item = _item.id_vnd_parc;
                -- org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            delete from tb_mov_bnc
            where 
                id_emp = new.id_emp and
                tp_org = 'VND' and
                id_org = new.id_vnd and
                id_org_item = _item.id_vnd_parc;
--                 org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            fetch _list into _item;
                
        end loop;
            
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_parc_cli_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete record;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.CLI' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_parc_cli;
            -- org = 'ROM_FRETE.CLI.' || old.id_rom_frete || '.' || old.id_rom_frete_parc_cli;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
    
        select * into _rom_frete
        from tb_rom_frete
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _rom_frete.id_tom, new.id_rom_frete, new.id_rom_frete_parc_cli, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.CLI.' || new.id_rom_frete || '.' || new.id_rom_frete_parc_cli, 'ROM_FRETE.CLI', new.id_rom_frete, new.id_rom_frete_parc_cli, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             new.id_plano_ct,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_item_parc_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete_item record;
    _rom_frete record;
    _descr varchar;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.ITEM' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_item and
            org = 'ROM_FRETE.ITEM.' || old.id_rom_frete || '.' || old.id_rom_frete_item || '.' || old.id_rom_frete_item_parc;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
    
        select
            tb_rom_frete.*,
            trim(substring(tb_part_tom.nome, 1, 15)) as nome_tom,
            trim(substring(tb_part_dest.nome, 1, 15)) as nome_dest
        into _rom_frete
        from tb_rom_frete
        left outer join tb_part as tb_part_tom on
            (tb_rom_frete.id_tom = tb_part_tom.id_part)
        left outer join tb_part as tb_part_dest on
            (tb_rom_frete.id_dest = tb_part_dest.id_part)
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
            
        select * into _rom_frete_item
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete and
            id_rom_frete_item = new.id_rom_frete_item;
    
        _id_ct := nextval('sq_ct');
        
        _descr := _rom_frete.nome_tom || ' / ' || _rom_frete.nome_dest || ' R. ' || _rom_frete.id_rom_frete;-- || ' D. ' || _rom_frete.vl_qtd;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             obs,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _rom_frete_item.id_colab, new.id_rom_frete, new.parc, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.ITEM.' || new.id_rom_frete || '.' || new.id_rom_frete_item || '.' || new.id_rom_frete_item_parc, 'ROM_FRETE.ITEM', new.id_rom_frete, new.id_rom_frete_item, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             _descr,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_forn_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'REQ_COLAB.FORN' and
            id_org = old.id_req_colab and
            id_org_item = old.id_req_colab_parc_forn;
            -- org = 'REQ_COLAB.FORN.' || old.id_req_colab || '.' || old.id_req_colab_parc_forn;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _req_colab
        from tb_req_colab
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             obs,
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct, id_cnt_cst,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _req_colab.id_forn, new.id_req_colab, new.id_req_colab_parc_forn, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             new.obs,
             'REQ_COLAB.FORN.' || new.id_req_colab || '.' || new.id_req_colab_parc_forn, 'REQ_COLAB.FORN', new.id_req_colab, new.id_req_colab_parc_forn, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             new.id_plano_ct, new.id_cnt_cst,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_req_colab_parc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _req_colab record;
    _descr varchar;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'REQ_COLAB.COLAB' and
            id_org = old.id_req_colab and
            id_org_item = old.id_req_colab_parc_colab;
            -- org = 'REQ_COLAB.COLAB.' || old.id_req_colab || '.' || old.id_req_colab_parc_colab;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
    
        select 
            tb_req_colab.*,
            tb_part.nome as nome_forn
        into _req_colab
        from tb_req_colab
        left outer join tb_part on
            (tb_req_colab.id_forn = tb_part.id_part)
        where
            id_emp = new.id_emp and
            id_req_colab = new.id_req_colab;
    
        _id_ct := nextval('sq_ct');
        
        _descr := 'REQ ' || _req_colab.id_req_colab || ' ' || _req_colab.nome_forn;
        
        if (new.qtd_parc > 1) then
            _descr := _descr || ' ' || new.id_req_colab_parc_colab || '/' || new.qtd_parc;
        end if;
        
        if (coalesce(new.obs, '') <> '') then
            _descr := _descr || ' ' || new.obs;
        end if; 
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             obs, id_veic,
             id_plano_ct, id_cnt_cst,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _req_colab.id_colab, new.id_req_colab, new.id_req_colab_parc_colab, new.qtd_parc,
             _req_colab.dt_req_colab, new.dt_venc, new.vl_parc, 'P', 
             'REQ_COLAB.COLAB.' || new.id_req_colab || '.' || new.id_req_colab_parc_colab, 'REQ_COLAB.COLAB', new.id_req_colab, new.id_req_colab_parc_colab, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             _descr, _req_colab.id_veic,
             new.id_plano_ct, new.id_cnt_cst,
             new.vl_parc, 0, 0, 0, 0, 
             _req_colab.id_usr_ult_alt, _req_colab.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pdc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'PDC_COLAB' and
            id_org = old.id_pdc_colab;
            -- org = 'PDC_COLAB.' || old.id_pdc_colab;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org,
             id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_colab, new.id_pdc_colab, 1, 1,
             new.dt_pdc_colab, new.dt_venc, new.vl_tot, 'P', 
             'PDC_COLAB.' || new.id_pdc_colab, 'PDC_COLAB', new.id_pdc_colab, 
             _op_fnc.id_op_fnc, 0, new.vl_tot, 
             new.id_plano_ct,
             new.vl_tot, 0, 0, 0, 0, 
             new.id_usr_ult_alt, new.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _stat_ct varchar;
begin
    _app_con := fc_app_con();
    
    
    if (tg_op = 'UPDATE') then
        select stat into _stat_ct
        from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'NF' and
            id_org = old.id_nf and
            id_org_item = old.id_nf_parc;
            -- org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
    
        if (_stat_ct = 'Q') then
            return new;
        end if;
    end if;

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'NF' and
            id_org = old.id_nf and
            id_org_item = old.id_nf_parc;
            -- org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'NF' and
            id_org = old.id_nf and
            id_org_item = old.id_nf_parc;
            -- org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select 
                tb_nf.tp_emis as tp_emis_nf,
                tb_nat_op.* 
            into 
                _nat_op
            from tb_nf
            join tb_nat_op on
                (tb_nf.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_nf.id_emp = new.id_emp and
                tb_nf.id_nf = new.id_nf;
                
            _gera_fin :=
                (_nat_op.tp_emis_nf = '[P]' and _nat_op.op like '%[NF_EMT__GER_FIN]%') or
                (_nat_op.tp_emis_nf = '[T]' and _nat_op.op like '%[NF_REC__GER_FIN]%');
                
                
            if (_op_fnc.gera_ct and _gera_fin) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, 
                     org, tp_org, id_org, id_org_item,
                     obs, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct, id_cnt_cst,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, 'NF', new.id_nf, new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc, 0, new.vl_parc, 
                     new.id_plano_ct, new.id_cnt_cst,
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt, _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, tp_org, id_org, id_org_item,
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct, id_cnt_cst,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, 'NF', new.id_nf, new.id_nf_parc,
                     _nf.id_part_emt, 'PEND',
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt, _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_plano_ct, new.id_cnt_cst,
                     new.id_op_fnc);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_fact_item_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _fact record;
    _nr_doc varchar;
    _app_con varchar;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                tp_org = 'FACT' and
                id_org = old.id_fact and
                id_org_item = old.id_fact_item;
                -- org = 'FACT.' || old.id_fact || '.' || old.id_fact_item;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _fact
            from tb_fact
            where
                id_emp = new.id_emp and
                id_fact = new.id_fact;
                
                    
            if (_op_fnc.gera_ct) then
                    
                _nr_doc := new.nr_ch;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_fact || '/' || new.id_fact_item;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, tp_org, id_org, id_org_item,
                     id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_ult_alt, dt_hr_ult_alt)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _fact.id_cli, _nr_doc, new.id_fact_item, 0,
                     _fact.dt_fact, new.dt_venc, new.vl_doc, 'P', 
                     new.nome_emit_ch, new.cpf_cnpj_emit_ch, new.id_bnc_ch, new.ag_ch, new.cnt_ch, null,
                     'FACT.' || new.id_fact || '.' || new.id_fact_item, 'FACT', new.id_fact, new.id_fact_item, 
                     new.id_op_fnc, 0, new.vl_doc, 
                     null,
                     new.vl_doc, 0, 0, 0, 0, 
                     _fact.id_usr_ult_alt, _fact.dt_hr_ult_alt);
                
            end if;

        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _ct record;
    _op varchar;
    _descr varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'CT_PAGTO' and
            id_org = old.id_ct and
            id_org_item = old.id_ct_pagto;
            -- org = 'CT_PAGTO.' || old.id_ct || '.' || old.id_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        select * into _ct
        from tb_ct
        where
            id_emp = new.id_emp and
            id_ct = new.id_ct;
        
        if (_ct.tp_ct = 'R') then
            _op := 'D';
        else
            _op := 'C';
        end if;
        
        
        _descr := '';
        
        if (_ct.org like 'MOV_COLAB.ADTO%') then
            _descr := 'ADTO ' || _ct.id_ct;
        end if;
        
        if (new.descr is not null) then
            _descr := _descr || ' - ' || new.descr;
        end if;
        
        
        
        insert into tb_mov_bnc
            (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
             org, tp_org, id_org, id_org_item,
             id_part, sit_conc,
             id_usr, id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
             id_ct_ctb_d, id_ct_ctb_c,
             id_plano_ct, id_cnt_cst,
             id_op_fnc)
        values
            (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_pagto, new.dt_pagto, new.nr_doc, _op, new.vl_pagto, _descr, false,
             'CT_PAGTO.' || new.id_ct || '.' || new.id_ct_pagto, 'CT_PAGTO', new.id_ct, new.id_ct_pagto,
             _ct.id_part, 'PEND',
             new.id_usr_ult_alt, new.id_usr_ult_alt, new.dt_hr_ult_alt, new.id_usr_ult_alt, new.dt_hr_ult_alt,
             _ct.id_ct_ctb_d, _ct.id_ct_ctb_c,
             new.id_plano_ct, new.id_cnt_cst,
             new.id_op_fnc);
    end if;
                     
                     
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    else
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
    _nr_doc integer;
    
    _vl_quit numeric;
    _vl_rest numeric;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        select sum(tb_bx_ct__ct.vl_quit), min(tb_bx_ct__ct.vl_rest) into _vl_quit, _vl_rest
        from tb_bx_ct__ct
        where
            tb_bx_ct__ct.id_emp_ct = new.id_emp and
            tb_bx_ct__ct.id_ct = new.id_ct;
    
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and (new.tp_doc = 'CH' or new.tp_doc = 'CH_PRZ')) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, 
                 id_part,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, 'CT', new.id_ct, 
                 new.id_part,
                 new.id_op_fnc);
        end if;

        
    elsif (tg_op = 'DELETE') then
        if (old.fat) then
            update tb_ct set
                stat = 'P',
                id_fat = null
            where
                id_fat = old.id_ct;
        end if;
        
        if (coalesce(old.id_fat, 0) > 0) then
            raise exception 'Esta conta esta vinculada a uma fatura e nao pode ser excluida';
            return null;
        end if;
        
        
        if (old.tp_ct = 'R') and (old.org = 'MOV_COLAB.ADTO') and (_app_con <> 'NEO_UNI') then
        
            delete from tb_recibo
            where
                id_emp = old.id_emp and
                org = 'MOV_COLAB.ADTO.' || old.id_ct;
                
        end if;
                

        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
                
            if (coalesce(old.org, '') like 'BX_MOV_FUNC.%') then
                _aux := regexp_split_to_array(old.org, '\.');
                
                update tb_mov_func set
                    id_bx_mov_func = null,
                    sit = 'P'
                where
                    id_emp = old.id_emp and
                    id_bx_mov_func = cast(_aux[2] as integer);
            end if;
                
        end if;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if ( (tg_op = 'INSERT' or (tg_op = 'UPDATE' and coalesce(new.nr_doc, '') = '') ) 
        and _app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') and (new.tp_ct = 'R') then
            _nr_doc := fc_num_blt(new.id_emp, new.id_op_fnc, new.id_cnt_bnc);
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    if ((tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con = 'NEO_UNI')) then
        new.vl_quit := _vl_quit;
        new.vl_rest := _vl_rest;
        
        if (_vl_rest <= 0) then
            new.stat := 'Q';
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_contr_frete_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _contr_frete record;
    _op_fnc record;
    _stat_ct varchar;
begin
    if (tg_op = 'UPDATE') then
        select stat into _stat_ct
        from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'CONTR_FRETE.PAGTO' and
            id_org = old.id_contr_frete and
            id_org_item = old.id_contr_frete_pagto;
            -- org = 'CONTR_FRETE.PAGTO.' || old.id_contr_frete || '.' || old.id_contr_frete_pagto;
    
        if (_stat_ct = 'Q') then
            return new;
        end if;
    end if;


    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'CONTR_FRETE.PAGTO' and
            id_org = old.id_contr_frete and
            id_org_item = old.id_contr_frete_pagto;
            -- org = 'CONTR_FRETE.PAGTO.' || old.id_contr_frete || '.' || old.id_contr_frete_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'CONTR_FRETE.PAGTO' and
            id_org = old.id_contr_frete and
            id_org_item = old.id_contr_frete_pagto;
            -- org = 'CONTR_FRETE.PAGTO.' || old.id_contr_frete || '.' || old.id_contr_frete_pagto;
        
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        select * into _contr_frete
        from tb_contr_frete
        where
            id_emp = new.id_emp and
            id_contr_frete = new.id_contr_frete;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 id_cnt_bnc, id_op_fnc, vl_quit, vl_rest,
                 org, tp_org, id_org, id_org_item,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _contr_frete.id_tom, new.nr_doc,
                 _contr_frete.dt_emis, new.dt_venc, new.vl_pagto, 'P', 
                 new.id_cnt_bnc, new.id_op_fnc, 0, new.vl_pagto,
                 'CONTR_FRETE.PAGTO.' || new.id_contr_frete || '.' || new.id_contr_frete_pagto, 'CONTR_FRETE.PAGTO', new.id_contr_frete, new.id_contr_frete_pagto, 
                 _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt, _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, id_org_item,
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _contr_frete.dt_emis, new.dt_venc, new.nr_doc, 'C', new.vl_pagto, new.obs, false,
                 'CONTR_FRETE.PAGTO.' || new.id_contr_frete || '.' || new.id_contr_frete_pagto, 'CONTR_FRETE.PAGTO', new.id_contr_frete, new.id_contr_frete_pagto,
                 _contr_frete.id_tom, 'PEND',
                 _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt, _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_contr_frete_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    
    _sit varchar;
    
    _id_ct integer;
    _num integer;
    _cte record;
begin
    if (tg_op = 'INSERT') then
    
        _sit := 'P';
        new.num := fc_get_num_contr_frete(new.id_emp);
        
    elsif (tg_op = 'UPDATE') then
        
        select stat into _sit 
        from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'CONTR_FRETE' and
            id_org = old.id_contr_frete;
            -- org = 'CONTR_FRETE.' || old.id_contr_frete;
    
    end if;
        
    if (tg_op = 'DELETE') or (tg_op = 'UPDATE' and _sit = 'P') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'CONTR_FRETE' and
            id_org = old.id_contr_frete;
            -- org = 'CONTR_FRETE.' || old.id_contr_frete;
            
    end if;
        
    if (tg_op = 'INSERT') or (tg_op = 'UPDATE' and _sit = 'P') then
            
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
            
        select * into _cte
        from tb_cte
        where
            id_emp = new.id_emp and
            id_cte = new.id_cte;
            
        _id_ct := nextval('sq_ct');
                
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, id_veic,
             org, tp_org, id_org,
             id_op_fnc, vl_quit, vl_rest, 
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_part, new.num, 1, 1,
             new.dt_emis, new.dt_venc, new.vl_tot, 'P', _cte.id_veic,
             'CONTR_FRETE.' || new.id_contr_frete, 'CONTR_FRETE', new.id_contr_frete,
             _op_fnc.id_op_fnc, 0, new.vl_tot, 
             new.vl_tot, 0, 0, 0, 0, 
             new.id_usr_ult_alt, new.dt_hr_ult_alt);
                
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;
    _op varchar;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
        
            if (_bx_ct.op = 'A') then
                _op := ifthen(new.op = 'C', 'R', 'P');
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'R', 'P');
            end if;
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, id_op_fnc, vl_quit, vl_rest,
                 org, tp_org, id_org, id_org_item,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), _op, _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, new.id_op_fnc, 0, new.vl_pagto,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto, 
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        _descr_part := '';
        
        if (_bx_ct.op = 'A') then
            _descr := 'ACERTO ' || _bx_ct.num_doc;
            
            if (new.obs is not null) then
                _descr_part := ' - ' || new.obs;
            end if;
          
        elsif (_bx_ct.org like 'BX_MOV_FUNC.%' and coalesce(new.obs, '') <> '') then
            
            _descr := new.obs;
            
        else
            select nome into _descr_part
            from tb_part
            where
                id_part = _bx_ct.id_part;
                
            if (_descr_part is null) then
                _descr_part := '';
            else
                _descr_part := ' ' || _descr_part;
            end if;
            
            if (new.obs is not null) then
                _descr_part := _descr_part || ' ' || new.obs;
            end if;
            
            _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
        
            if (_bx_ct.op = 'A') then
                _op := new.op;
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'C', 'D');
            end if;
        
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, id_org_item,
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, _op, new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
    _mov_colab boolean;
    _obs varchar;
begin
    _app_con := fc_app_con();
    
    _mov_colab := false;
    
    if (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_recibo
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
        _mov_colab := true;
        
        if (coalesce(old.id_fat, 0) > 0) then
            update tb_ct set
                stat = 'P'
            where
                id_ct = old.id_fat;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (coalesce(new.id_fat, 0) > 0) then
            update tb_ct set
                stat = 'B',
                vl_sub_tot = new.vl_sub_tot,
                vl_desc = new.vl_desc,
                vl_perc_desc = new.vl_desc_perc,
                vl_acr = new.vl_acr,
                vl_perc_acr = new.vl_acr_perc,
                vl_ct = new.vl_tot,
                vl_quit = new.vl_pag,
                vl_rest = new.vl_rest
            where
                id_ct = new.id_fat;
        end if;
    end if;
    
    if (tg_op = 'UPDATE') then
        if (old.vl_prox_deb <> new.vl_prox_deb) or (old.vl_prox_cred <> new.vl_prox_cred) then
            _mov_colab := true;
        end if;
    end if;
    
    if (_mov_colab) then
        delete from tb_ct
        where
            id_emp = old.id_emp and
            (tp_org = 'MOV_COLAB.CRED.ACT' or tp_org = 'MOV_COLAB.DEB.ACT') and
            id_org = old.id_bx_ct;
            -- (org = 'MOV_COLAB.CRED.ACT.' || old.id_bx_ct or
            --  org = 'MOV_COLAB.DEB.ACT.' || old.id_bx_ct);    
    end if;
    
    _mov_colab := false;

    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        _mov_colab := true;  
    end if;
    
    if (tg_op = 'UPDATE') then
        if (old.vl_prox_deb <> new.vl_prox_deb) or (old.vl_prox_cred <> new.vl_prox_cred) then
            _mov_colab := true;
        end if;
    end if;
    
    if (_mov_colab) then
        if (new.op = 'A') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
        
            _obs := 'ACERTO N ' || new.num_doc;
                
            if (new.obs is not null) then
                _obs := trim(_obs || ' ' || new.obs);
            end if;
                
            if (coalesce(new.vl_prox_deb, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, tp_org, id_org,
                     id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs,
                     id_veic)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_deb, 'P', 
                     'MOV_COLAB.DEB.ACT.' || new.id_bx_ct, 'MOV_COLAB.DEB.ACT', new.id_bx_ct, 
                     _op_fnc.id_op_fnc, 0, new.vl_prox_deb,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     _obs,
                     new.id_veic);
            end if;
            
            
            if (coalesce(new.vl_prox_cred, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, tp_org, id_org,
                     id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs,
                     id_veic)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_cred, 'P', 
                     'MOV_COLAB.CRED.ACT.' || new.id_bx_ct, 'MOV_COLAB.CRED.ACT', new.id_bx_ct, 
                     _op_fnc.id_op_fnc, 0, new.vl_prox_cred,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     _obs,
                     new.id_veic);
            end if;
        
        end if;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

