drop view vw_item_pt_prc;

CREATE OR REPLACE VIEW public.vw_item_pt_prc
AS
select
    id_emp || '.' || id_item || '.' || id_pt_prc || '.' || id_und_med as id,
    *
from
(

    select
        tb_item_emp.id_emp,
        tb_item.id_item,
        0 as id_pt_prc,
        tb_item.id_und_med as id_und_med_item,
        tb_item.id_und_med,
        tb_item_emp.vl_prc_vnd,
        tb_item.cd_bar,
        'M' as tp_conv,
        1 as vl_conv
    from tb_item
    left outer join tb_item_emp on
        (tb_item.id_item = tb_item_emp.id_item)
        

    union all


    select
        tb_item_emp.id_emp,
        tb_item.id_item,
        0 as id_pt_prc,
        tb_item.id_und_med as id_und_med_item,
        tb_item_und_med.id_und_med,
        case
            when ( coalesce(tb_item_und_med.vl_prc_vnd, 0) <> 0) then tb_item_und_med.vl_prc_vnd
            else tb_item_emp.vl_prc_vnd * tb_item_und_med.vl_conv
        end as vl_prc_vnd,
        tb_item_und_med.cd_bar,
        tb_item_und_med.tp_conv,
        coalesce(tb_item_und_med.vl_conv, 1) as vl_conv
    from tb_item
    join tb_item_und_med on
        (tb_item.id_item = tb_item_und_med.id_item)
    left outer join tb_item_emp on
        (tb_item.id_item = tb_item_emp.id_item)

    union all


    select
        tb_item_emp.id_emp,
        tb_item.id_item,
        tb_pt_prc.id_pt_prc,
        tb_item.id_und_med as id_und_med_item,
        tb_item.id_und_med,
        case
            when ( coalesce(tb_item_pt_prc.vl_prc_vnd, 0) <> 0) then tb_item_pt_prc.vl_prc_vnd
            else tb_item_emp.vl_prc_vnd
        end as vl_prc_vnd,
        tb_item.cd_bar,
        'M' as tp_conv,
        1 as vl_conv
    from tb_item
    join tb_pt_prc on (true)
    left outer join tb_item_emp on
        (tb_item.id_item = tb_item_emp.id_item)
    left outer join tb_item_pt_prc on
        (tb_item.id_item = tb_item_pt_prc.id_item and
         (tb_item.id_und_med = tb_item_pt_prc.id_und_med or tb_item_pt_prc.id_und_med = '') and
         tb_pt_prc.id_pt_prc = tb_item_pt_prc.id_pt_prc and
         tb_item_pt_prc.id_emp = tb_item_emp.id_emp)

    union all

    select
        tb_item_emp.id_emp,
        tb_item.id_item,
        tb_pt_prc.id_pt_prc,
        tb_item.id_und_med as id_und_med_item,
        tb_item_und_med.id_und_med,
        case
            when ( coalesce(tb_item_pt_prc.vl_prc_vnd, 0) <> 0 ) then tb_item_pt_prc.vl_prc_vnd
            when ( coalesce(tb_item_und_med.vl_prc_vnd, 0) <> 0 ) then tb_item_und_med.vl_prc_vnd
            else tb_item_emp.vl_prc_vnd * coalesce(tb_item_und_med.vl_conv, 1)
        end as vl_prc_vnd,
        tb_item_und_med.cd_bar,
        tb_item_und_med.tp_conv,
        coalesce(tb_item_und_med.vl_conv, 1) as vl_conv
    from tb_item
    join tb_pt_prc on (true)
    left outer join tb_item_emp on
        (tb_item.id_item = tb_item_emp.id_item)
    join tb_item_und_med on
        (tb_item.id_item = tb_item_und_med.id_item)
    left outer join tb_item_pt_prc on
        (tb_item_und_med.id_item = tb_item_pt_prc.id_item and
         tb_item_und_med.id_und_med = tb_item_pt_prc.id_und_med and
         tb_pt_prc.id_pt_prc = tb_item_pt_prc.id_pt_prc and
         tb_item_pt_prc.id_emp = tb_item_emp.id_emp)


) as tb
order by
    id_item,
    id_emp,
    id_pt_prc,
    id_und_med