SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc, 0, new.vl_pagto,
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        if (new.obs is not null) then
            _descr_part := _descr_part || ' ' || new.obs;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
    
    _id_ct integer;
    _num integer;
begin
    _app_con := fc_app_con();
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'INSERT') then
            if (new.op = 'A') then
                new.num_doc = fc_get_num_act_viagem(new.id_emp);
            end if;
        end if;
        
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_part_cred
  ADD COLUMN dt_nasc DATE;

CREATE TABLE public.tb_part_bnc (
  id_part INTEGER NOT NULL, 
  id_part_bnc INTEGER NOT NULL, 
  id_bnc VARCHAR(3), 
  ag VARCHAR(20), 
  cnt VARCHAR(20), 
  obs VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_part_bnc PRIMARY KEY(id_part, id_part_bnc)
) ;

ALTER TABLE public.tb_part
  ADD COLUMN dt_venc_cnh DATE;

ALTER TABLE public.tb_part
  ADD COLUMN pis VARCHAR(20);

ALTER TABLE public.tb_part
  ADD COLUMN reserv VARCHAR(20);

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN id_cnt_cst INTEGER;

ALTER TABLE public.tb_mov_fnc
  ADD COLUMN id_cnt_cst INTEGER;

ALTER TABLE public.tb_bx_ct_pagto
  ADD COLUMN id_cnt_cst INTEGER;

ALTER TABLE public.tb_ct
  ADD COLUMN id_cnt_cst INTEGER;

ALTER TABLE public.tb_part_bnc
  ADD CONSTRAINT fk__part_bnc__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_fnc
  ADD CONSTRAINT fk__mov_fnc__cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT fk__mov_bnc__id_cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct
  ADD CONSTRAINT fk__ct__cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_bx_ct_pagto
  ADD CONSTRAINT fk__bx_ct_pagto__cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

