SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc, 0, new.vl_pagto);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND');
        /*
        else
            
            perform fc_gera_mov_fnc(new.id_emp, _bx_ct.id_cx, _bx_ct.id_usr, _bx_ct.dt_bx, cast(current_time as time), trim(_descr || _descr_part),
                ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_bx_ct, new.id_op_fnc);
                */
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _tb_org varchar,
  _id_emp integer,
  _id_org integer
)
RETURNS boolean AS
$body$
declare
    _org_list refcursor;
    _org record;
    _seq integer;
begin

    if (_tb_org = 'tb_vnd') then
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'VND.' || _id_org || '%';
    
        open _org_list for
            select
                tb_vnd.id_cx as id_cx,
                tb_vnd.id_usr as id_usr,
                tb_vnd.id_vnd as id_org,
                tb_vnd.dt_vnd as dt_lanc,
                cast('VENDA: ' || coalesce(tb_vnd.nome, '') as varchar) as descr,
                cast('C' as varchar) as op,
                sum(tb_vnd_parc.vl_parc) as vl_lanc,
                cast('VND.' || tb_vnd.id_vnd || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_vnd.id_vnd as varchar) as doc,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt
            from tb_vnd
            join tb_vnd_parc on
                (tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
            join tb_op_fnc on
                (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_vnd.id_emp = _id_emp and
                tb_vnd.id_vnd = _id_org
            group by
                tb_vnd.id_cx,
                tb_vnd.id_vnd,
                tb_vnd.id_usr,
                tb_vnd.dt_vnd,
                tb_vnd.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt;
                
    elsif (_tb_org = 'tb_bx_ct') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'BX.' || _id_org || '%';
    
        open _org_list for
            select
                tb_bx_ct.id_cx as id_cx,
                tb_bx_ct.id_usr as id_usr,
                tb_bx_ct.id_bx_ct as id_org,
                tb_bx_ct.dt_bx as dt_lanc,
                cast(ifthen(tb_bx_ct.tp_bx = 'R', 'REC: ', 'PAG: ') || coalesce(tb_part.nome, '') as varchar) as descr,
                cast(ifthen(tb_bx_ct.tp_bx = 'R', 'C', 'D') as varchar) as op,
                sum(tb_bx_ct_pagto.vl_pagto) as vl_lanc,
                cast('BX.' || tb_bx_ct.id_bx_ct || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_bx_ct.id_bx_ct as varchar) as doc,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt
            from tb_bx_ct
            join tb_bx_ct_pagto on
                (tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp and
                 tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct)
            left outer join tb_part on
                (tb_bx_ct.id_part = tb_part.id_part)
            join tb_op_fnc on
                (tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_bx_ct.id_emp = _id_emp and
                tb_bx_ct.id_bx_ct = _id_org
            group by
                tb_bx_ct.id_cx,
                tb_bx_ct.id_bx_ct,
                tb_bx_ct.tp_bx,
                tb_bx_ct.id_usr,
                tb_bx_ct.dt_bx,
                tb_part.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt;
    
    elsif (_tb_org = 'tb_nf') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'NF.' || _id_org || '%';
    
        open _org_list for
            select
                tb_nf.id_cx as id_cx,
                tb_nf.id_usr as id_usr,
                tb_nf.id_nf as id_org,
                tb_nf.dt_op as dt_lanc,
                cast('NF: ' || coalesce(tb_nf.fant_emt, '') as varchar) as descr,
                cast('D' as varchar) as op,
                sum(tb_nf_parc.vl_parc) as vl_lanc,
                cast('NF.' || tb_nf.id_nf || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_nf.num as varchar) as doc,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt
            from tb_nf
            join tb_nf_parc on
                (tb_nf.id_emp = tb_nf_parc.id_emp and
                 tb_nf.id_nf = tb_nf_parc.id_nf)
            join tb_op_fnc on
                (tb_nf_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true) and
                 tb_op_fnc.tp_op_fnc = 'DIN')
            where
                tb_nf.id_emp = _id_emp and
                tb_nf.id_nf = _id_org and
                tb_nf.tp_emis = '[T]'
            group by
                tb_nf.id_cx,
                tb_nf.id_nf,
                tb_nf.id_usr,
                tb_nf.dt_op,
                tb_nf.num,
                tb_nf.fant_emt,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt;
    
    end if;

    


    fetch _org_list into _org;
    
    while found loop

        _seq := fc_get_seq_mov_fnc(_id_emp, _org.id_cx);
    
        insert into tb_mov_fnc
            (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
             descr, op, vl_lanc, org, id_org, id_op_fnc, doc,
             dt_hr_cad, dt_hr_ult_alt, id_usr_cad, id_usr_ult_alt, id_est_cad, id_est_ult_alt, seq)
        values
            (_id_emp, nextval('sq_mov_fnc'), _org.id_cx, _org.id_usr, _org.dt_lanc, substring(cast(current_time as varchar), 1, 8)::time, 
             _org.descr, _org.op, _org.vl_lanc, _org.org, _org.id_org, _org.id_op_fnc, _org.doc,
             _org.dt_hr_cad, CURRENT_TIMESTAMP, _org.id_usr_cad, _org.id_usr_ult_alt, _org.id_est_cad, _org.id_est_ult_alt, _seq);
    
        fetch _org_list into _org;
        
    end loop;
    
    close _org_list;


    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

