CREATE TABLE public.tb_mov_func (
  id_emp INTEGER NOT NULL, 
  id_mov_func INTEGER NOT NULL, 
  id_part INTEGER, 
  dt_emis DATE, 
  dt_venc DATE, 
  op VARCHAR(1), 
  vl_lanc NUMERIC(12,4), 
  descr VARCHAR(255), 
  org VARCHAR(30), 
  id_org INTEGER, 
  sit VARCHAR(20), 
  id_recibo INTEGER, 
  nr_doc VARCHAR(50), 
  id_plano_ct VARCHAR(100), 
  CONSTRAINT pk_mov_func PRIMARY KEY(id_emp, id_mov_func)
) ;

ALTER TABLE public.tb_mov_func
  ADD CONSTRAINT fk__mov_func__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_func
  ADD CONSTRAINT fk__mov_func__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_func
  ADD CONSTRAINT fk__mov_func__plano_ct FOREIGN KEY (id_plano_ct)
    REFERENCES public.tb_plano_ct(id_plano_ct)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_func
  ADD CONSTRAINT fk__mov_func__recibo FOREIGN KEY (id_emp, id_recibo)
    REFERENCES public.tb_recibo(id_emp, id_recibo)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;


SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_recibo_bf (
)
RETURNS trigger AS
$body$
begin
    update tb_mov_func set
        id_recibo = null,
        sit = 'P'
    where
        id_emp = old.id_emp and
        id_recibo = old.id_recibo;
    
    
    return old;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;


CREATE TRIGGER tr_recibo_bf
  BEFORE DELETE 
  ON public.tb_recibo FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_recibo_bf();