CREATE OR REPLACE FUNCTION public.fc_num_blt (
  _id_emp integer,
  _id_op_fnc integer,
  _id_cnt_bnc integer
)
RETURNS integer AS
$body$
declare
    _nr_blt_ini integer;
    _nr_blt_fin integer;

    _nr_doc integer;
begin
    _nr_blt_ini := cast(coalesce(fc_get_emp_cnf(_id_emp, 01015), '1') as integer);
    _nr_blt_fin := cast(coalesce(fc_get_emp_cnf(_id_emp, 01016), '99999') as integer);

    select coalesce(max(cast(regexp_replace(coalesce(nr_doc, '0'), '[^0-9]', '', 'gi') as integer)), _nr_blt_ini -1) + 1 into _nr_doc
    from tb_ct
    where
        id_emp = _id_emp and
        id_op_fnc = _id_op_fnc and
        id_cnt_bnc = _id_cnt_bnc and
        cast(regexp_replace(coalesce(nr_doc, '0'), '[^0-9]', '', 'gi') as integer) between _nr_blt_ini and _nr_blt_fin;

    if (_nr_doc > _nr_blt_fin) then
        raise exception 'Numeracao de boleto indisponivel: %-%', _nr_blt_ini, _nr_blt_fin;
    end if;

    return _nr_doc;        
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;