DROP TRIGGER tr_mnt_estq_bf ON public.tb_mnt_estq;

DROP TRIGGER tr_mnt_estq_item_bf ON public.tb_mnt_estq_item;

CREATE OR REPLACE FUNCTION public.fc_fec_ped_compl (
  _id_emp integer,
  _id_ped integer,
  _id_dep_org integer,
  _id_dep_dst integer
)
RETURNS boolean AS
$body$
declare
    _ped record;
    _ped_item record;
    _ped_item_list refcursor;
    
    _id_mnt_estq integer;
    _id_mnt_estq_item integer;
    
    _id_grd_estq varchar;
begin

    _id_grd_estq := fc_get_emp_cnf(_id_emp, 08004);
    
    select * into _ped
    from tb_ped
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    delete from tb_mnt_estq
    where
        id_emp = _id_emp and
        org = 'PED.' || _id_ped and
        id_org = _id_ped;
        
        
    _id_mnt_estq := nextval('sq_mnt_estq');
    
    insert into tb_mnt_estq
        (id_emp, id_mnt_estq, dt_mnt_estq, op, id_dep_org, id_dep_dst, descr, org, id_org)
    values
        (_id_emp, _id_mnt_estq, _ped.dt_ped, 'T', _id_dep_org, _id_dep_dst, 'CARREGAMENTO COMPLEMENTAR ' || _id_ped, 'PED.' || _id_ped, _id_ped);
        
    
    open _ped_item_list for
        select
            tb_ped_item.*,
            tb_item.id_und_med as id_und_med_item
        from tb_ped_item
        join tb_item on
            (tb_ped_item.id_item = tb_item.id_item)
        where
            id_emp = _id_emp and
            id_ped = _id_ped;
            
    fetch _ped_item_list into _ped_item;
    
    _id_mnt_estq_item := 0;
    
    while found loop
        
        _id_mnt_estq_item := _id_mnt_estq_item + 1;
    
        insert into tb_mnt_estq_item
            (id_emp, id_mnt_estq, id_mnt_estq_item, id_item, id_grd_estq, id_und_med, vl_qtd, 
             id_und_med_mov, vl_qtd_mov, 
             op, id_dep_org, id_dep_dst)
        values
            (_id_emp, _id_mnt_estq, _id_mnt_estq_item, _ped_item.id_item, _id_grd_estq, _ped_item.id_und_med_item, _ped_item.vl_qtd, 
             _ped_item.id_und_med_item, _ped_item.vl_qtd,
             'T', _id_dep_org, _id_dep_ds);
            
        fetch _ped_item_list into _ped_item;
        
    end loop;
    
    
    update tb_ped set
        sit = 'F'
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_mnt_estq_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _app_con varchar;
    _op varchar;
    _upd_op varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
            if (lower(old.op) <> 'i') then
                _upd_op := ifthen(lower(old.op) = 'e', 's', 'e');
                
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_dst, old.id_grd_estq, _upd_op, old.vl_qtd_mov);
                
                if (old.id_dep_org is not null) then
                    perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_org, old.id_grd_estq, old.op, old.vl_qtd_mov);
                end if;
            end if;
        end if;
        
        
        if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
            if (lower(new.op) <> 'i') then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_dst, new.id_grd_estq, new.op, new.vl_qtd_mov);
                    
                if (new.id_dep_org is not null) then
                    perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_org, new.id_grd_estq, 's', new.vl_qtd_mov);
                end if;
            end if;
        end if;
    end if;
    
    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_mnt_estq_item
  ADD COLUMN id_dep_org INTEGER;

ALTER TABLE public.tb_mnt_estq_item
  ADD COLUMN id_dep_dst INTEGER;

ALTER TABLE public.tb_mnt_estq_item
  ADD COLUMN op VARCHAR(1);

DROP FUNCTION public.fc_tr_mnt_estq_bf();

ALTER TABLE public.tb_mnt_estq_item
  ADD CONSTRAINT fk__mnt_estq_item__dep_org FOREIGN KEY (id_emp, id_dep_org)
    REFERENCES public.tb_dep(id_emp, id_dep)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mnt_estq_item
  ADD CONSTRAINT fk__mnt_estq_item__dep_dst FOREIGN KEY (id_emp, id_dep_dst)
    REFERENCES public.tb_dep(id_emp, id_dep)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_mnt_estq_item_bf BEFORE INSERT OR UPDATE OR DELETE 
ON public.tb_mnt_estq_item FOR EACH ROW 
EXECUTE PROCEDURE public.fc_tr_mnt_estq_item_bf();

