CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _tb_org varchar,
  _id_emp integer,
  _id_org integer
)
RETURNS boolean AS
$body$
declare
    _org_list refcursor;
    _org record;
begin

    if (_tb_org = 'tb_vnd') then
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'VND.' || _id_org || '%';
    
        open _org_list for
            select
                tb_vnd.id_cx as id_cx,
                tb_vnd.id_usr as id_usr,
                tb_vnd.id_vnd as id_org,
                tb_vnd.dt_vnd as dt_lanc,
                'VENDA ' || coalesce(tb_vnd.nome, '') as descr,
                'C' as op,
                sum(tb_vnd_parc.vl_parc) as vl_lanc,
                'VND.' || tb_vnd.id_vnd || '.' || tb_op_fnc.id_op_fnc as org,
                tb_op_fnc.id_op_fnc,
                tb_vnd.id_vnd as doc
            from tb_vnd
            join tb_vnd_parc on
                (tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
            join tb_op_fnc on
                (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_vnd.id_emp = _id_emp and
                tb_vnd.id_vnd = _id_org
            group by
                tb_vnd.id_cx,
                tb_vnd.id_vnd,
                tb_vnd.id_usr,
                tb_vnd.dt_vnd,
                tb_vnd.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr;
                
    elsif (_tb_org = 'tb_bx_ct') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'BX.' || _id_org || '%';
    
        open _org_list for
            select
                tb_bx_ct.id_cx as id_cx,
                tb_bx_ct.id_usr as id_usr,
                tb_bx_ct.id_bx_ct as id_org,
                tb_bx_ct.dt_bx as dt_lanc,
                ifthen(tb_bx_ct.tp_bx = 'R', 'RECEBIMENTO ', 'PAGAMENTO ') || coalesce(tb_part.nome, '') as descr,
                ifthen(tb_bx_ct.tp_bx = 'R', 'C', 'D') as op,
                sum(tb_bx_ct_pagto.vl_pagto) as vl_lanc,
                'BX.' || tb_bx_ct.id_bx_ct || '.' || tb_op_fnc.id_op_fnc as org,
                tb_op_fnc.id_op_fnc,
                tb_bx_ct.id_bx_ct as doc
            from tb_bx_ct
            join tb_bx_ct_pagto on
                (tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp and
                 tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct)
            left outer join tb_part on
                (tb_bx_ct.id_part = tb_part.id_part)
            join tb_op_fnc on
                (tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_bx_ct.id_emp = _id_emp and
                tb_bx_ct.id_bx_ct = _id_org
            group by
                tb_bx_ct.id_cx,
                tb_bx_ct.id_bx_ct,
                tb_bx_ct.tp_bx,
                tb_bx_ct.id_usr,
                tb_bx_ct.dt_bx,
                tb_part.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr;
    
    elsif (_tb_org = 'tb_nf') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'NF.' || _id_org || '%';
    
        open _org_list for
            select
                tb_nf.id_cx as id_cx,
                tb_nf.id_usr as id_usr,
                tb_nf.id_nf as id_org,
                tb_nf.dt_op as dt_lanc,
                'NF ' || coalesce(tb_nf.fant_emt, '') as descr,
                'D' as op,
                sum(tb_nf_parc.vl_parc) as vl_lanc,
                'NF.' || tb_nf.id_nf || '.' || tb_op_fnc.id_op_fnc as org,
                tb_op_fnc.id_op_fnc,
                tb_nf.num as doc
            from tb_nf
            join tb_nf_parc on
                (tb_nf.id_emp = tb_nf_parc.id_emp and
                 tb_nf.id_nf = tb_nf_parc.id_nf)
            join tb_op_fnc on
                (tb_nf_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_nf.id_emp = _id_emp and
                tb_nf.id_nf = _id_org and
                tb_nf.tp_emis = '[T]'
            group by
                tb_nf.id_cx,
                tb_nf.id_nf,
                tb_nf.id_usr,
                tb_nf.dt_op,
                tb_nf.num,
                tb_nf.fant_emt,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr;
    
    end if;

    fetch _org_list into _org;
    
    while found loop
    
        insert into tb_mov_fnc
            (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
             descr, op, vl_lanc, org, id_org, id_op_fnc, doc)
        values
            (_id_emp, nextval('sq_mov_fnc'), _org.id_cx, _org.id_usr, _org.dt_lanc, substring(cast(current_time as varchar), 1, 8)::time, 
             _org.descr, _org.op, _org.vl_lanc, _org.org, _org.id_org, _org.id_op_fnc, _org.doc);
    
        fetch _org_list into _org;
        
    end loop;


    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;