CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _id_emp integer,
  _id_cx integer,
  _id_usr integer,
  _dt_lanc date,
  _hr_lanc time,
  _descr varchar,
  _op varchar,
  _vl_lanc numeric,
  _org varchar,
  _id_org integer,
  _id_op_fnc integer
)
RETURNS bigint AS
$body$
declare
    _mov_fnc record;
    _id_mov_fnc bigint;
    _op_fnc record;
begin
    select * into _op_fnc
    from tb_op_fnc
    where
        id_op_fnc = _id_op_fnc;
        
    if (coalesce(_op_fnc.mov_cx, true) = false) then
        return 0;
    end if;

    select * into _mov_fnc
    from tb_mov_fnc
    where
        id_emp = _id_emp and
        op = _op and
        org = _org and
        id_org = _id_org;
    
    if found then
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            id_mov_fnc = _mov_fnc.id_mov_fnc;
    end if;
    
    _id_mov_fnc := nextval('sq_mov_fnc');
        
    insert into tb_mov_fnc
        (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
         descr, op, vl_lanc, org, id_org, id_op_fnc, doc)
    values
        (_id_emp, _id_mov_fnc, _id_cx, _id_usr, _dt_lanc, substring(cast(_hr_lanc as varchar), 1, 8)::time, 
         _descr, _op, _vl_lanc, _org, _id_org, _id_op_fnc, _id_org);
    
    return _id_mov_fnc;    
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_bnc_af (
)
RETURNS trigger AS
$body$
begin
    if ((tg_op = 'UPDATE') and (old.op = 'T')) or (tg_op = 'DELETE') then
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'MOV_BNC.' || old.id_mov_bnc;
                
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'MOV_BNC.' || old.id_mov_bnc;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        if (new.op = 'T') and (new.dst = 'C') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_fnc
                (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc, 
                 doc, descr, op, vl_lanc, 
                 org, id_org)
            values
                (new.id_emp, nextval('sq_mov_fnc'), new.id_dst, new.id_usr, new.dt_emis, substring(cast(current_time as varchar), 1, 8)::time,
                 new.nr_doc, new.descr, 'C', new.vl_lanc, 'MOV_BNC.' || new.id_mov_bnc, new.id_mov_bnc);
        end if;
        
        if (new.op = 'T') and (new.dst = 'B') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 nr_doc, descr, op, vl_lanc, conc,
                 org, id_org)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_dst, new.dt_emis, new.dt_venc, 
                 new.nr_doc, new.descr, 'C', new.vl_lanc, false, 'MOV_BNC.' || new.id_mov_bnc, new.id_mov_bnc);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN dst VARCHAR(10);

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN id_dst INTEGER;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN id_usr INTEGER;

ALTER TABLE public.tb_op_fnc
  ADD COLUMN saldo_cx BOOLEAN;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT fk__mov_bnc__usr FOREIGN KEY (id_usr)
    REFERENCES public.tb_usr(id_usr)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_mov_bnc_af AFTER INSERT OR UPDATE OR DELETE 
ON public.tb_mov_bnc FOR EACH ROW 
EXECUTE PROCEDURE public.fc_tr_mov_bnc_af();

