CREATE SEQUENCE public.sq_cx
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_cx RESTART WITH 2;

CREATE SEQUENCE public.sq_mov_cx
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_mov_cx RESTART WITH 11;

CREATE SEQUENCE public.sq_mov_fnc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_mov_fnc RESTART WITH 15;

CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _id_emp integer,
  _id_cx integer,
  _id_usr integer,
  _dt_lanc date,
  _hr_lanc time,
  _descr varchar,
  _op varchar,
  _vl_lanc numeric,
  _org varchar,
  _id_org integer
)
RETURNS bigint AS
$body$
declare
    _mov_fnc record;
    _id_mov_fnc bigint;
begin
    select * into _mov_fnc
    from tb_mov_fnc
    where
        id_emp = _id_emp and
        op = _op and
        org = _org and
        id_org = _id_org;
    
    if found then
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org = _org and
            id_org = _id_org;
    end if;
    
    _id_mov_fnc := nextval('sq_mov_fnc');
        
    insert into tb_mov_fnc 
        (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
         descr, op, vl_lanc, org, id_org)
    values
        (_id_emp, _id_mov_fnc, _id_cx, _id_usr, _dt_lanc, _hr_lanc, 
         _descr, _op, _vl_lanc, _org, _id_org);
    
    return _id_mov_fnc;    
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _cond_pagto record;
BEGIN
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (new.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = new.id_cond_pagto;
            
            perform fc_gera_mov_fnc(new.id_emp, new.id_cx, new.id_usr, new.dt_vnd, cast(current_time as time), 'VENDA ' || new.nome || ' ' || _cond_pagto.descr,
                'C', new.vl_tot, 'VND', new.id_vnd);
        end if;
    elsif (tg_op = 'DELETE') then
        if (old.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = old.id_cond_pagto;

            perform fc_gera_mov_fnc(old.id_emp, old.id_cx, old.id_usr, old.dt_vnd, cast(current_time as time), 'VENDA CANCELADA '  || old.nome || ' ' || _cond_pagto.descr,
                'D', old.vl_tot, 'VND', old.id_vnd);
        end if;
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_mov_cx
  ADD COLUMN id_usr INTEGER;

ALTER TABLE public.tb_mov_cx
  RENAME COLUMN dt_ab TO dt_i;

ALTER TABLE public.tb_mov_cx
  ADD COLUMN hr_i TIME WITHOUT TIME ZONE;

ALTER TABLE public.tb_mov_cx
  RENAME COLUMN dt_fc TO dt_f;

ALTER TABLE public.tb_mov_cx
  ADD COLUMN hr_f TIME WITHOUT TIME ZONE;

ALTER TABLE public.tb_mov_cx
  RENAME COLUMN vl_deb TO vl_trc_i;

ALTER TABLE public.tb_mov_cx
  RENAME COLUMN vl_cred TO vl_tot_mov;

ALTER TABLE public.tb_mov_cx
  ADD COLUMN vl_tot_apur NUMERIC(12,4);

ALTER TABLE public.tb_mov_cx
  ADD COLUMN vl_trc_f NUMERIC(12,4);

ALTER TABLE public.tb_mov_cx
  ADD COLUMN vl_dif NUMERIC(12,4);

ALTER TABLE public.tb_mov_cx
  ADD COLUMN sit VARCHAR(1);

ALTER TABLE public.tb_mov_cx
  ADD COLUMN obs VARCHAR(255);

CREATE TABLE public.tb_mov_cx__mov_fnc (
  id_emp INTEGER NOT NULL, 
  id_mov_cx INTEGER NOT NULL, 
  id_mov_fnc BIGINT NOT NULL
) WITHOUT OIDS;

CREATE TABLE public.tb_mov_cx_apur (
  id_emp INTEGER NOT NULL, 
  id_mov_cx INTEGER NOT NULL, 
  id_op_fnc INTEGER NOT NULL, 
  vl_apur NUMERIC(12,4)
) WITHOUT OIDS;

CREATE TABLE public.tb_mov_fnc (
  id_emp INTEGER NOT NULL, 
  id_mov_fnc BIGINT NOT NULL, 
  id_cx INTEGER, 
  id_usr INTEGER, 
  dt_lanc DATE, 
  hr_lanc TIME WITHOUT TIME ZONE, 
  descr VARCHAR(150), 
  op VARCHAR(1), 
  vl_lanc NUMERIC(12,4), 
  org VARCHAR(30), 
  id_org INTEGER
) WITHOUT OIDS;

ALTER TABLE public.tb_rel_col
  ALTER COLUMN descr TYPE VARCHAR(1000);

ALTER TABLE public.tb_rel_item_col
  ALTER COLUMN descr TYPE VARCHAR(1000);

ALTER TABLE public.tb_rel_tot
  ALTER COLUMN descr TYPE VARCHAR(1000);

ALTER TABLE public.tb_vnd
  ADD COLUMN id_usr INTEGER;

DROP TABLE public.tb_mov_cx_op_fnc;

ALTER TABLE public.tb_mov_fnc
  ADD CONSTRAINT pk_mov_fnc 
    PRIMARY KEY (id_emp, id_mov_fnc);

ALTER TABLE public.tb_mov_cx_apur
  ADD CONSTRAINT pk_mov_cx_apur 
    PRIMARY KEY (id_emp, id_mov_cx, id_op_fnc);

ALTER TABLE public.tb_mov_cx__mov_fnc
  ADD CONSTRAINT pk_mov_cx__mov_fnc 
    PRIMARY KEY (id_emp, id_mov_cx, id_mov_fnc);

ALTER TABLE public.tb_mov_fnc
  ADD CONSTRAINT fk__mov_fnc__usr FOREIGN KEY (id_usr)
    REFERENCES public.tb_usr(id_usr)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_fnc
  ADD CONSTRAINT fk__mov_fnc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_fnc
  ADD CONSTRAINT fk__mov_fnc__cx FOREIGN KEY (id_emp, id_cx)
    REFERENCES public.tb_cx(id_emp, id_cx)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_cx_apur
  ADD CONSTRAINT fk__mov_cx_apur__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_cx_apur
  ADD CONSTRAINT fk__mov_cx_apur__mov_cx FOREIGN KEY (id_emp, id_mov_cx)
    REFERENCES public.tb_mov_cx(id_emp, id_mov_cx)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_cx__mov_fnc
  ADD CONSTRAINT fk__mov_cx__mov_fnc__mov_fnc FOREIGN KEY (id_emp, id_mov_fnc)
    REFERENCES public.tb_mov_fnc(id_emp, id_mov_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_cx__mov_fnc
  ADD CONSTRAINT fk__mov_cx__mov_fnc___mov_cx FOREIGN KEY (id_emp, id_mov_cx)
    REFERENCES public.tb_mov_cx(id_emp, id_mov_cx)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_cx
  ADD CONSTRAINT fk__mov_cx__usr FOREIGN KEY (id_usr)
    REFERENCES public.tb_usr(id_usr)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_vnd_af
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_vnd FOR EACH ROW 
  EXECUTE PROCEDURE public.tr_vnd_af();

