CREATE SEQUENCE public.sq_ped
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_ped RESTART WITH 4;

CREATE OR REPLACE FUNCTION public.fc_get_carenc_ct_rec (
  _id_part integer,
  _id_emp integer
)
RETURNS integer AS
$body$
declare
    _carenc integer;
    _carenc_str varchar;
BEGIN
    select carenc_acr into _carenc
    from tb_part
    where
        id_part = _id_part;
        
    if (_carenc = 0 or _carenc is null) then
        select val into _carenc_str
        from tb_emp_cnf
        where
            id_emp = _id_emp and
            id_cnf = 6003;
            
        if (_carenc_str = '') then
            _carenc := 0;
        else
            _carenc := cast(_carenc_str as integer);
        end if;
    end if;
    
    return _carenc;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_get_perc_acr_ct_rec (
  _id_part integer,
  _id_emp integer
)
RETURNS numeric AS
$body$
declare
    _vl numeric;
    _vl_str varchar;
BEGIN
    select vl_perc_acr into _vl
    from tb_part
    where
        id_part = _id_part;
        
    if (_vl = 0 or _vl is null) then
        select val into _vl_str
        from tb_emp_cnf
        where
            id_emp = _id_emp and
            id_cnf = 6002;
            
        if (_vl_str = '') then
            _vl := 0;
        else
            _vl := cast(replace(_vl_str, ',','.') as numeric(12,4));
        end if;
    end if;
    
    return _vl;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_nf, id_nf_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _nf.id_part_emt, cast(_nf.num as varchar), new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', new.id_nf, new.id_nf_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_nf, id_nf_parc)
                values
                    (new.id_emp, nextval('sq_ch'), 'P', _nf.id_part_emt, new.emit, new.cpf_cnpj,
                     _nf.dt_op, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_nf, new.id_nf_parc);
                     
            end if;
            
        end if;
            
    
        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_ch
  ADD COLUMN id_nf INTEGER;

ALTER TABLE public.tb_ch
  ADD COLUMN id_nf_parc INTEGER;

ALTER TABLE public.tb_ct
  ADD COLUMN dt_prev DATE;

ALTER TABLE public.tb_ct
  ADD COLUMN descr_prev VARCHAR(255);

ALTER TABLE public.tb_ct
  ADD COLUMN id_nf INTEGER;

ALTER TABLE public.tb_ct
  ADD COLUMN id_nf_parc INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN carenc_acr INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN vl_perc_acr NUMERIC(12,4);

CREATE TABLE public.tb_ped (
  id_emp INTEGER NOT NULL, 
  id_ped INTEGER NOT NULL, 
  dt_ped DATE, 
  id_vndr INTEGER, 
  vl_qtd NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  vl_peso_liq NUMERIC(12,4), 
  vl_peso_brt NUMERIC(12,4), 
  obs VARCHAR(255), 
  sit VARCHAR(1)
) WITHOUT OIDS;

CREATE TABLE public.tb_ped_item (
  id_emp INTEGER NOT NULL, 
  id_ped INTEGER NOT NULL, 
  id_ped_item INTEGER NOT NULL, 
  id_item INTEGER, 
  id_und_med VARCHAR(5), 
  vl_qtd NUMERIC(12,4), 
  vl_unt NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  vl_peso_liq NUMERIC(12,4), 
  vl_peso_brt NUMERIC(12,4), 
  id_und_med_mov VARCHAR(5), 
  vl_qtd_mov NUMERIC(12,4), 
  id_dep INTEGER, 
  id_grd_estq VARCHAR(20)
) WITHOUT OIDS;

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT pk_ped_item 
    PRIMARY KEY (id_emp, id_ped, id_ped_item);

ALTER TABLE public.tb_ped
  ADD CONSTRAINT pk_ped 
    PRIMARY KEY (id_emp, id_ped);

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT fk__ped_item__und_med FOREIGN KEY (id_und_med)
    REFERENCES public.tb_und_med(id_und_med)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT fk__ped_item__ped FOREIGN KEY (id_emp, id_ped)
    REFERENCES public.tb_ped(id_emp, id_ped)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT fk__ped_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT fk__ped_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT fk__ped_item__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped
  ADD CONSTRAINT fk__ped__vndr FOREIGN KEY (id_vndr)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped
  ADD CONSTRAINT fk__ped__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_nf_parc_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_nf_parc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_nf_parc_bf();

