CREATE SEQUENCE public.sq_fc_st
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_fc_st RESTART WITH 5;

CREATE OR REPLACE FUNCTION public.fc_fc_st (
  _id_emp integer,
  _dt_fc date
)
RETURNS integer AS
$body$
DECLARE
    _list refcursor;
    _item record;
    _qtd integer;
BEGIN
    open _list for
        select
            id_emp,
            id_cx,
            dt_vnd,
            sum(qtd_vnd) as qtd_vnd,
            sum(qtd_canc) as qtd_canc,
            sum(vl_tot_vnd) as vl_tot_vnd,
            sum(vl_tot_canc) as vl_tot_canc
        from
        (
            select 
                id_emp,
                id_cx,
                dt_vnd,
                case 
                    when not coalesce(canc, false) then 1
                    else 0
                end as qtd_vnd,
                case 
                    when coalesce(canc, false) then 1
                    else 0
                end as qtd_canc,
                case 
                    when not coalesce(canc, false) then vl_tot
                    else 0
                end as vl_tot_vnd,
                case 
                    when coalesce(canc, false) then vl_tot
                    else 0
                end as vl_tot_canc
            from tb_vnd
            where
                id_emp = _id_emp and
                dt_vnd = _dt_fc and
                ((coalesce(canc, false) = false and coalesce(sinc_scanntech, false) = true) or
                 (coalesce(canc, false) = true and coalesce(sinc_scanntech_canc, false) = true))
        ) as tb
        where
            not exists (
                select 1
                from tb_fc_st
                where
                    tb_fc_st.id_emp = tb.id_emp and
                    tb_fc_st.id_cx = tb.id_cx and
                    tb_fc_st.dt_fc = tb.dt_vnd
            )
        group by
            id_emp,
            id_cx,
            dt_vnd;
            
    fetch _list into _item;
    
    _qtd := 0;
    
    while found loop
        insert into tb_fc_st
            (id_emp, id_fc_st, id_cx, dt_fc, 
             vl_qtd_vnd, vl_tot_vnd, 
             vl_qtd_canc, vl_tot_canc, 
             sit)
        values 
            (_item.id_emp, nextval('sq_fc_st'), _item.id_cx, _item.dt_vnd,
             _item.qtd_vnd, _item.vl_tot_vnd,
             _item.qtd_canc, _item.vl_tot_canc,
             'P');
    
        _qtd := _qtd + 1;
        
        fetch _list into _item;
    end loop;
    
    return _qtd;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_item
  ADD COLUMN id_ncm_alt VARCHAR(20);

CREATE TABLE public.tb_fc_st (
  id_emp INTEGER NOT NULL, 
  id_fc_st INTEGER NOT NULL, 
  id_cx INTEGER, 
  dt_fc DATE, 
  vl_qtd_vnd INTEGER, 
  vl_tot_vnd NUMERIC(12,2), 
  vl_qtd_canc INTEGER, 
  vl_tot_canc NUMERIC(12,2), 
  sit VARCHAR(10), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_fc_st PRIMARY KEY(id_emp, id_fc_st)
) ;

ALTER TABLE public.tb_vnd
  ADD COLUMN sinc_scanntech BOOLEAN;

ALTER TABLE public.tb_vnd
  ADD COLUMN sinc_scanntech_canc BOOLEAN;

ALTER TABLE public.tb_fc_st
  ADD CONSTRAINT fk__fc_st__cx FOREIGN KEY (id_emp, id_cx)
    REFERENCES public.tb_cx(id_emp, id_cx)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fc_st
  ADD CONSTRAINT fk__fc_st__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
