CREATE OR REPLACE FUNCTION public.fc_nf_at_prc (
  _id_emp integer,
  _id_nf integer,
  _alt_prc_vnd boolean,
  _alt_prc_cst boolean
)
RETURNS boolean AS
$body$
declare
    _nf record;
    _nf_item_list refcursor;
    _nf_item record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
    _item_alt boolean;    
begin
    select * into _nf
    from tb_nf
    where
        id_emp = _id_emp and
        id_nf = _id_nf;
        
    if (_nf.tp_emis = '[T]') or (_nf.tp_emis = '[P]' and _nf.tp_op = '[E]' ) then
        
        select * into _nat_op
        from tb_nat_op
        where
            id_nat_op = _nf.id_nat_op;
            
            
        open _nf_item_list for 
            select *
            from tb_nf_item
            where
                id_emp = _id_emp and
                id_nf  = _id_nf;
        
        fetch _nf_item_list into _nf_item;
        
        while found loop
            _item_alt := false;
            
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_CST]%') or (_alt_prc_cst) then
                _item_alt := true;
                
                update tb_item_emp set
                	vl_cst_brt        = _nf_item.vl_tot / _nf_item.vl_qtd_mov,
                    vl_desp           = _nf_item.vl_frete + _nf_item.vl_seg + _nf_item.vl_out,
                    vl_perc_icms      = _nf_item.vl_perc_icms_prc,
                    vl_icms           = _nf_item.vl_icms_prc,
                    vl_perc_icms_st   = _nf_item.vl_perc_icms_st_prc,
                    vl_icms_st        = _nf_item.vl_icms_st_prc,
                    vl_perc_fcp_st    = _nf_item.vl_perc_fcp_st_prc,
                    vl_fcp_st         = _nf_item.vl_fcp_st_prc,
                    vl_perc_ipi       = _nf_item.vl_perc_ipi_prc,
                    vl_ipi            = _nf_item.vl_ipi_prc,
                    vl_perc_pis       = _nf_item.vl_perc_pis_prc,
                    vl_pis            = _nf_item.vl_pis_prc,
                    vl_perc_cofins    = _nf_item.vl_perc_cofins_prc,
                    vl_cofins         = _nf_item.vl_cofins_prc,
                    vl_desc           = _nf_item.vl_desc,
                    vl_cst_rep        = _nf_item.vl_cst_rep,
                    vl_cst_med        = _nf_item.vl_cst_med,
                    dt_ult_cmp        = _nf.dt_op,
                    id_usr_ult_alt    = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt     = _nf_item.dt_hr_ult_alt,
                    comp_ult_alt      = _nf_item.comp_ult_alt
                where
                    id_emp  = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
            end if;
                
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%') or (_alt_prc_vnd) then
                _item_alt := true;
                
                update tb_item_emp set
                    vl_out              = _nf_item.vl_out_prc,
                    vl_perc_desp_op     = _nf_item.vl_perc_desp_op_prc,
                    vl_desp_op          = _nf_item.vl_desp_op_prc,
                    vl_perc_luc         = _nf_item.vl_perc_luc_prc,
                    vl_luc              = _nf_item.vl_luc_prc,
                    vl_prc_vnd          = _nf_item.vl_prc_vnd,
                    id_usr_ult_alt      = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt       = _nf_item.dt_hr_ult_alt,
                    comp_ult_alt        = _nf_item.comp_ult_alt
                where
                    id_emp  = _nf_item.id_emp and
                    id_item = _nf_item.id_item;

                if (coalesce(_nf_item.promo, false)) then
                    update tb_item_emp set
                        promo            = _nf_item.promo,
                        vl_prc_vnd_promo = _nf_item.vl_prc_vnd_promo,
                        id_usr_ult_alt   = _nf_item.id_usr_ult_alt,
                        dt_hr_ult_alt    = _nf_item.dt_hr_ult_alt,
                        comp_ult_alt     = _nf_item.comp_ult_alt
                    where
                        id_emp  = _nf_item.id_emp and
                        id_item = _nf_item.id_item;
                end if;
            end if;
            
            if (_item_alt) then
                update tb_item set
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt  = _nf_item.dt_hr_ult_alt,
                    comp_ult_alt   = _nf_item.comp_ult_alt
                where
                    id_item = _nf_item.id_item;
            end if;
        
            fetch _nf_item_list into _nf_item;
            
        end loop;
            
    end if;
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;