SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;
    _op varchar;
    _id_part_ct integer;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
        
            if (_bx_ct.op = 'A') then
                _op := ifthen(new.op = 'C', 'R', 'P');
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'R', 'P');
            end if;
            
            if (_op_fnc.id_part_ct is not null and _bx_ct.op = 'A' and _op_fnc.tp_op_fnc = 'REQ') then
                _id_part_ct := _op_fnc.id_part_ct;
            else
                _id_part_ct := _bx_ct.id_part;
            end if;
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, id_op_fnc, vl_quit, vl_rest,
                 org, tp_org, id_org, id_org_item,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), _op, _op_fnc.tp_op_fnc, _id_part_ct, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, new.id_op_fnc, 0, new.vl_pagto,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto, 
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        _descr_part := '';
        
        if (_bx_ct.op = 'A') then
            _descr := 'ACERTO ' || _bx_ct.num_doc;
            
            if (new.obs is not null) then
                _descr_part := ' - ' || new.obs;
            end if;
          
        elsif (_bx_ct.org like 'BX_MOV_FUNC.%' and coalesce(new.obs, '') <> '') then
            
            _descr := new.obs;
            
        else
            select nome into _descr_part
            from tb_part
            where
                id_part = _bx_ct.id_part;
                
            if (_descr_part is null) then
                _descr_part := '';
            else
                _descr_part := ' ' || _descr_part;
            end if;
            
            if (new.obs is not null) then
                _descr_part := _descr_part || ' ' || new.obs;
            end if;
            
            if (_bx_ct.org like 'PAG_COOP%') then
                _descr := 'PAGTO PROD COOP ';
            else
                _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
            end if;
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
        
            if (_bx_ct.op = 'A') then
                _op := new.op;
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'C', 'D');
            end if;
        
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, id_org_item,
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, _op, new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_tp_contr_frete
  ADD COLUMN bc_taxa_coop VARCHAR(10);

ALTER TABLE public.tb_op_fnc
  ADD COLUMN id_part_ct INTEGER;

ALTER TABLE public.tb_op_fnc
  ADD CONSTRAINT fk__op_fnc__part_ct FOREIGN KEY (id_part_ct)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

