SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
    _nr_doc integer;
    
    _vl_quit numeric;
    _vl_rest numeric;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        select sum(tb_bx_ct__ct.vl_quit), min(tb_bx_ct__ct.vl_rest) into _vl_quit, _vl_rest
        from tb_bx_ct__ct
        where
            tb_bx_ct__ct.id_emp_ct = new.id_emp and
            tb_bx_ct__ct.id_ct = new.id_ct;
    
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and (new.tp_doc = 'CH' or new.tp_doc = 'CH_PRZ')) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part,
                 new.id_op_fnc);
        end if;

        
    elsif (tg_op = 'DELETE') then
        if (old.fat) then
            update tb_ct set
                stat = 'P',
                id_fat = null
            where
                id_fat = old.id_ct;
        end if;
        
        if (coalesce(old.id_fat, 0) > 0) then
            raise exception 'Esta conta esta vinculada a uma fatura e nao pode ser excluída';
            return null;
        end if;
        
        
        if (old.tp_ct = 'R') and (old.org = 'MOV_COLAB.ADTO') and (_app_con <> 'NEO_UNI') then
        
            delete from tb_recibo
            where
                id_emp = old.id_emp and
                org = 'MOV_COLAB.ADTO.' || old.id_ct;
                
        end if;
                

        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
                
            if (coalesce(old.org, '') like 'BX_MOV_FUNC.%') then
                _aux := regexp_split_to_array(old.org, '\.');
                
                update tb_mov_func set
                    id_bx_mov_func = null,
                    sit = 'P'
                where
                    id_emp = old.id_emp and
                    id_bx_mov_func = cast(_aux[2] as integer);
            end if;
                
        end if;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if ( (tg_op = 'INSERT' or (tg_op = 'UPDATE' and coalesce(new.nr_doc, '') = '') ) 
        and _app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') and (new.tp_ct = 'R') then
            _nr_doc := fc_num_blt(new.id_emp, new.id_op_fnc, new.id_cnt_bnc);
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    if ((tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con = 'NEO_UNI')) then
        new.vl_quit := _vl_quit;
        new.vl_rest := _vl_rest;
        
        if (_vl_rest <= 0) then
            new.stat := 'Q';
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
    _mov_colab boolean;
    _obs varchar;
begin
    _app_con := fc_app_con();
    
    _mov_colab := false;
    
    if (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_recibo
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
        _mov_colab := true;
        
        if (coalesce(old.id_fat, 0) > 0) then
            update tb_ct set
                stat = 'P'
            where
                id_ct = old.id_fat;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (coalesce(new.id_fat, 0) > 0) then
            update tb_ct set
                stat = 'B',
                vl_sub_tot = new.vl_sub_tot,
                vl_desc = new.vl_desc,
                vl_perc_desc = new.vl_desc_perc,
                vl_acr = new.vl_acr,
                vl_perc_acr = new.vl_acr_perc,
                vl_ct = new.vl_tot,
                vl_quit = new.vl_pag,
                vl_rest = new.vl_rest
            where
                id_ct = new.id_fat;
        end if;
    end if;
    
    if (tg_op = 'UPDATE') then
        if (old.vl_prox_deb <> new.vl_prox_deb) or (old.vl_prox_cred <> new.vl_prox_cred) then
            _mov_colab := true;
        end if;
    end if;
    
    if (_mov_colab) then
        delete from tb_ct
        where
            id_emp = old.id_emp and
            (org = 'MOV_COLAB.CRED.ACT.' || old.id_bx_ct or
             org = 'MOV_COLAB.DEB.ACT.' || old.id_bx_ct);    
    end if;
    
    _mov_colab := false;

    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        _mov_colab := true;  
    end if;
    
    if (tg_op = 'UPDATE') then
        if (old.vl_prox_deb <> new.vl_prox_deb) or (old.vl_prox_cred <> new.vl_prox_cred) then
            _mov_colab := true;
        end if;
    end if;
    
    if (_mov_colab) then
        if (new.op = 'A') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
        
            _obs := 'ACERTO N ' || new.num_doc;
                
            if (new.obs is not null) then
                _obs := trim(_obs || ' ' || new.obs);
            end if;
                
            if (coalesce(new.vl_prox_deb, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs,
                     id_veic)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_deb, 'P', 
                     'MOV_COLAB.DEB.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_deb,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     _obs,
                     new.id_veic);
            end if;
            
            
            if (coalesce(new.vl_prox_cred, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs,
                     id_veic)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_cred, 'P', 
                     'MOV_COLAB.CRED.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_cred,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     _obs,
                     new.id_veic);
            end if;
        
        end if;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct__ct_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _op_bx varchar;
    _sit_ct varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
    
        select op into _op_bx
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;

        -- SE FOR RENEGOCIACAO DEIXA A CT INATIVA
        if (_op_bx = 'R') then
            _sit_ct := 'I';
        else
            _sit_ct := 'Q';
        end if;
            
        
        update tb_ct set
            stat = case when new.vl_rest = 0 then _sit_ct else 'P' end,
            vl_quit = coalesce(vl_quit, 0) + coalesce(new.vl_quit, 0),
            vl_rest = coalesce(new.vl_rest, 0),
            dt_hr_ult_alt = new.dt_hr_ult_alt,
            id_usr_ult_alt = new.id_usr_ult_alt,
            id_est_ult_alt = new.id_est_ult_alt
        where
            id_emp = new.id_emp_ct and
            id_ct = new.id_ct;
            
        if (new.id_plano_ct <> null) then
            update tb_ct set
                id_plano_ct = new.id_plano_ct
            where
                id_emp = new.id_emp_ct and
                id_ct = new.id_ct;
        end if;
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        if (coalesce(old.id_fat, 0) > 0) then
            _sit_ct := 'F';
        else
            _sit_ct := 'P';
        end if;
        
        update tb_ct set
            stat = _sit_ct,
            vl_quit = coalesce(vl_quit, 0) - coalesce(old.vl_quit, 0),
            vl_rest = coalesce(vl_rest, 0) + coalesce(old.vl_quit, 0) - coalesce(old.vl_acr, 0),
            dt_hr_ult_alt = old.dt_hr_ult_alt,
            id_usr_ult_alt = old.id_usr_ult_alt,
            id_est_ult_alt = old.id_est_ult_alt
        where
            id_emp = old.id_emp_ct and
            id_ct = old.id_ct;
            
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_bx_ct
  ADD COLUMN id_fat INTEGER;

ALTER TABLE public.tb_bx_ct__ct
  ADD COLUMN id_fat INTEGER;

