SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _id_plano_ct varchar;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
            
            delete from tb_mov_bnc
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _vnd
            from tb_vnd
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                
                
            select tb_nat_op.* into _nat_op
            from tb_vnd
            join tb_nat_op on
                (tb_vnd.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_vnd.id_emp = new.id_emp and
                tb_vnd.id_vnd = new.id_vnd;
                    
            _gera_fin := _nat_op.op like '%[VND__GER_FIN]%';

            if (_op_fnc.gera_ct and _gera_fin) then
                    
                _nr_doc := new.nr_doc;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
                
                _id_plano_ct := fc_get_emp_cnf(new.id_emp, 16200);
                
                if (_id_plano_ct = '') then
                    _id_plano_ct := null;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_veic)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, new.id_op_fnc, 0, new.vl_parc, 
                     _id_plano_ct,
                     new.vl_sub_tot, coalesce(new.vl_perc_desc, 0), coalesce(new.vl_desc, 0), coalesce(new.vl_perc_acr, 0), coalesce(new.vl_acr, 0), 
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     _vnd.id_veic);
                
                
                if (_op_fnc.tp_op_fnc = 'BLT') then
                    select * into _ct
                    from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_ct = _id_ct;
                        
                    new.nr_doc := _ct.nr_doc;
                    
--                    raise notice '12345 Boleto %', new.nr_doc;
                    
                elsif (_op_fnc.tp_op_fnc = 'DUP') then
                    new.nr_doc := cast(_id_ct as varchar);
                    
--                    raise notice '12345 Duplicata %', new.nr_doc;
                    
                end if;
            end if;
                
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                     _vnd.id_cli, 'PEND',
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
    
    _id_ct integer;
    _num integer;
begin
    _app_con := fc_app_con();
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'INSERT') then
            if (new.op = 'A') then
                new.num_doc = fc_get_num_act_viagem(new.id_emp);
                new.num_doc_part = fc_get_num_part_act_viagem(new.id_emp, new.id_part);
            end if;
        end if;
        
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_recibo
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
        delete from tb_ct
        where
            id_emp = old.id_emp and
            (org = 'MOV_COLAB.CRED.ACT.' || old.id_bx_ct or
             org = 'MOV_COLAB.DEB.ACT.' || old.id_bx_ct);
            
    end if;
    
    
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        if (new.op = 'A') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
        
            if (coalesce(new.vl_prox_deb, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_deb, 'P', 
                     'MOV_COLAB.DEB.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_deb,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     'ACERTO N ' || new.num_doc);
            end if;
            
            
            if (coalesce(new.vl_prox_cred, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_cred, 'P', 
                     'MOV_COLAB.CRED.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_cred,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     'ACERTO N ' || new.num_doc);
            end if;
        
        end if;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_get_num_part_act_viagem (
  _id_emp integer,
  _id_part integer
)
RETURNS integer AS
$body$
declare
    _num integer;
BEGIN
    select max(num_doc_part) into _num
    from tb_bx_ct
    where
        id_emp = _id_emp and
        id_part = _id_part and
        op = 'A';
    
    if (not _num is null) then
        return _num + 1;
    else
        return 1;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_bx_ct
  ADD COLUMN num_doc_part INTEGER;

ALTER TABLE public.tb_vnd
  ADD COLUMN id_veic INTEGER;

ALTER TABLE public.tb_vnd
  ADD CONSTRAINT fk__vnd__veic FOREIGN KEY (id_veic)
    REFERENCES public.tb_veic(id_veic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

