ALTER TABLE public.tb_nat_op
  DROP CONSTRAINT fk__nat_op__ct_ctb RESTRICT;

ALTER TABLE public.tb_mov_ctb
  DROP CONSTRAINT fk__mov_ctb__ct_ctb_d RESTRICT;

ALTER TABLE public.tb_mov_ctb
  DROP CONSTRAINT fk__mov_ctb__ct_ctb_c RESTRICT;

ALTER TABLE public.tb_grp_trib_nat_op
  DROP CONSTRAINT fk__grp_trib_nat_op__id_ct_ctb RESTRICT;

CREATE TABLE public.tb_veic (
  id_veic INTEGER NOT NULL, 
  cod INTEGER, 
  marca VARCHAR(150), 
  placa VARCHAR(10), 
  placa_car VARCHAR(10), 
  qtd_eixo INTEGER, 
  chassi VARCHAR(30), 
  renavan VARCHAR(30), 
  ano_mod VARCHAR(10), 
  dt_ult_vist DATE, 
  cor VARCHAR(20), 
  cod_antt VARCHAR(20), 
  tara INTEGER, 
  cap_kg INTEGER, 
  cap_m3 INTEGER, 
  tp_rod VARCHAR(20), 
  tp_car VARCHAR(20), 
  tp_veic VARCHAR(20), 
  tp_prop VARCHAR(20), 
  id_uf VARCHAR(2), 
  nome_prop VARCHAR(100), 
  cpf_cnpj_prop VARCHAR(20), 
  rntrc_prop VARCHAR(20), 
  ie_prop VARCHAR(20), 
  id_uf_prop VARCHAR(2), 
  tp_prop_cte VARCHAR(20), 
  obs TEXT, 
  CONSTRAINT pk_veic PRIMARY KEY(id_veic)
) ;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _id_plano_ct varchar;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
            
            delete from tb_mov_bnc
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _vnd
            from tb_vnd
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                
                
            select tb_nat_op.* into _nat_op
            from tb_vnd
            join tb_nat_op on
                (tb_vnd.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_vnd.id_emp = new.id_emp and
                tb_vnd.id_vnd = new.id_vnd;
                    
            _gera_fin := _nat_op.op like '%[VND__GER_FIN]%';

            if (_op_fnc.gera_ct and _gera_fin) then
                    
                _nr_doc := new.nr_doc;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
                
                _id_plano_ct := fc_get_emp_cnf(new.id_emp, 16200);
                
                if (_id_plano_ct = '') then
                    _id_plano_ct := null;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, new.id_op_fnc, 0, new.vl_parc, 
                     _id_plano_ct,
                     new.vl_sub_tot, new.vl_perc_desc, new.vl_desc, new.vl_perc_acr, new.vl_acr, 
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
                
                
                if (_op_fnc.tp_op_fnc = 'BLT') then
                    select * into _ct
                    from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_ct = _id_ct;
                        
                    new.nr_doc := _ct.nr_doc;
                    
--                    raise notice '12345 Boleto %', new.nr_doc;
                    
                elsif (_op_fnc.tp_op_fnc = 'DUP') then
                    new.nr_doc := cast(_id_ct as varchar);
                    
--                    raise notice '12345 Duplicata %', new.nr_doc;
                    
                end if;
            end if;
                
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                     _vnd.id_cli, 'PEND',
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select 
                tb_nf.tp_emis as tp_emis_nf,
                tb_nat_op.* 
            into 
                _nat_op
            from tb_nf
            join tb_nat_op on
                (tb_nf.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_nf.id_emp = new.id_emp and
                tb_nf.id_nf = new.id_nf;
                
            _gera_fin :=
                (_nat_op.tp_emis_nf = '[P]' and _nat_op.op like '%[NF_EMT__GER_FIN]%') or
                (_nat_op.tp_emis_nf = '[T]' and _nat_op.op like '%[NF_REC__GER_FIN]%');
                
                
            if (_op_fnc.gera_ct and _gera_fin) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc, 0, new.vl_parc, 
                     new.id_plano_ct,
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND',
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc, 0, new.vl_pagto,
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _tb_org varchar,
  _id_emp integer,
  _id_org integer,
  _id_mov_cx integer
)
RETURNS boolean AS
$body$
declare
    _org_list refcursor;
    _org record;
    _seq integer;
begin

    if (_tb_org = 'tb_vnd') then
        /*delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'VND.' || _id_org || '%';*/
    
        open _org_list for
            select
                tb_vnd.id_cx as id_cx,
                tb_vnd.id_usr as id_usr,
                tb_vnd.id_vnd as id_org,
                tb_vnd.dt_vnd as dt_lanc,
                cast(case when coalesce(tb_vnd.canc, false) then 'CANC VENDA: ' else 'VENDA: ' end || coalesce(tb_vnd.nome, '') as varchar) as descr,
                cast(case when coalesce(tb_vnd.canc, false) then 'D' else 'C' end as varchar) as op,
                sum(tb_vnd_parc.vl_parc) as vl_lanc,
                cast('VND.' || tb_vnd.id_vnd || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_vnd.id_vnd as varchar) as doc,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt,
                tb_vnd_parc.id_ct_ctb_d,
                tb_vnd_parc.id_ct_ctb_c
            from tb_vnd
            join tb_vnd_parc on
                (tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
            join tb_op_fnc on
                (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_vnd.id_emp = _id_emp and
                tb_vnd.tp_vnd = 'V' and
                tb_vnd.id_vnd = _id_org
            group by
                tb_vnd.id_cx,
                tb_vnd.id_vnd,
                tb_vnd.id_usr,
                tb_vnd.dt_vnd,
                tb_vnd.nome,
                tb_vnd.canc,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt,
                tb_vnd_parc.id_ct_ctb_d,
                tb_vnd_parc.id_ct_ctb_c;
                
    elsif (_tb_org = 'tb_bx_ct') then
    
        /*delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'BX.' || _id_org || '%';*/
    
        open _org_list for
            select
                tb_bx_ct.id_cx as id_cx,
                tb_bx_ct.id_usr as id_usr,
                tb_bx_ct.id_bx_ct as id_org,
                tb_bx_ct.dt_bx as dt_lanc,
                cast(
                    case 
                        when (coalesce(tb_bx_ct.op = 'R')) then 'RENEG: ' || coalesce(tb_part.nome, '')
                        when (tb_bx_ct.tp_bx = 'R') then ifthen(coalesce(tb_bx_ct.canc, false), 'ESTORNO DE ', '') || 'REC: ' || coalesce(tb_part.nome, '')
                        when (tb_bx_ct.tp_bx = 'P') then ifthen(coalesce(tb_bx_ct.canc, false), 'ESTORNO DE ', '') || 'PAG: ' || coalesce(tb_part.nome, '') 
                    end
                as varchar) as descr,
                cast(
                    case 
                        when (tb_bx_ct.tp_bx = 'R' and coalesce(tb_bx_ct.canc, false) = false) then 'C'
                        when (tb_bx_ct.tp_bx = 'R' and coalesce(tb_bx_ct.canc, false) = true) then 'D'
                        when (tb_bx_ct.tp_bx = 'P' and coalesce(tb_bx_ct.canc, false) = false) then 'D'
                        when (tb_bx_ct.tp_bx = 'P' and coalesce(tb_bx_ct.canc, false) = true) then 'C'
                    end 
                as varchar) as op,
--                cast(ifthen(tb_bx_ct.tp_bx = 'R', 'C', 'D') as varchar) as op,
                sum(tb_bx_ct_pagto.vl_pagto) as vl_lanc,
                cast('BX.' || tb_bx_ct.id_bx_ct || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_bx_ct.id_bx_ct as varchar) as doc,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt,
                tb_bx_ct_pagto.id_ct_ctb_d,
                tb_bx_ct_pagto.id_ct_ctb_c
            from tb_bx_ct
            join tb_bx_ct_pagto on
                (tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp and
                 tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct)
            left outer join tb_part on
                (tb_bx_ct.id_part = tb_part.id_part)
            join tb_op_fnc on
                (tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_bx_ct.id_emp = _id_emp and
                tb_bx_ct.id_bx_ct = _id_org
            group by
                tb_bx_ct.id_cx,
                tb_bx_ct.id_bx_ct,
                tb_bx_ct.tp_bx,
                tb_bx_ct.canc,
                tb_bx_ct.id_usr,
                tb_bx_ct.dt_bx,
                tb_part.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_bx_ct.op,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt,
                tb_bx_ct_pagto.id_ct_ctb_d,
                tb_bx_ct_pagto.id_ct_ctb_c;
    
    elsif (_tb_org = 'tb_nf') then
    
        /*delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'NF.' || _id_org || '%';*/
    
        open _org_list for
            select
                tb_nf.id_cx as id_cx,
                tb_nf.id_usr as id_usr,
                tb_nf.id_nf as id_org,
                tb_nf.dt_op as dt_lanc,
                cast(ifthen(coalesce(tb_nf.canc, false), 'CANC ', '') || 'NF: ' || coalesce(tb_nf.fant_emt, '') as varchar) as descr,
                cast(
                    case 
                        when (coalesce(tb_nf.canc, false) = false) then 'D'
                        else 'C'
                    end 
                as varchar) as op,
--                cast('D' as varchar) as op,
                sum(tb_nf_parc.vl_parc) as vl_lanc,
                cast('NF.' || tb_nf.id_nf || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_nf.num as varchar) as doc,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt,
                tb_nf_parc.id_ct_ctb_d,
                tb_nf_parc.id_ct_ctb_c
            from tb_nf
            join tb_nf_parc on
                (tb_nf.id_emp = tb_nf_parc.id_emp and
                 tb_nf.id_nf = tb_nf_parc.id_nf)
            join tb_op_fnc on
                (tb_nf_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true) and
                 tb_op_fnc.tp_op_fnc = 'DIN')
            where
                tb_nf.id_emp = _id_emp and
                tb_nf.id_nf = _id_org and
                tb_nf.tp_emis = '[T]'
            group by
                tb_nf.id_cx,
                tb_nf.id_nf,
                tb_nf.id_usr,
                tb_nf.dt_op,
                tb_nf.canc,
                tb_nf.num,
                tb_nf.fant_emt,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt,
                tb_nf_parc.id_ct_ctb_d,
                tb_nf_parc.id_ct_ctb_c;
    
    end if;

    


    fetch _org_list into _org;
    
    while found loop

        _seq := fc_get_seq_mov_fnc(_id_emp, _org.id_cx);
    
        insert into tb_mov_fnc
            (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
             descr, op, vl_lanc, org, id_org, id_op_fnc, doc,
             dt_hr_cad, dt_hr_ult_alt, id_usr_cad, id_usr_ult_alt, id_est_cad, id_est_ult_alt, 
             seq, id_mov_cx,
             id_ct_ctb_d, id_ct_ctb_c)
        values
            (_id_emp, nextval('sq_mov_fnc'), _org.id_cx, _org.id_usr, _org.dt_lanc, substring(cast(current_time as varchar), 1, 8)::time, 
             _org.descr, _org.op, _org.vl_lanc, _org.org, _org.id_org, _org.id_op_fnc, _org.doc,
             _org.dt_hr_cad, CURRENT_TIMESTAMP, _org.id_usr_cad, _org.id_usr_ult_alt, _org.id_est_cad, _org.id_est_ult_alt, 
             _seq, _id_mov_cx,
             _org.id_ct_ctb_d, _org.id_ct_ctb_c);
    
        fetch _org_list into _org;
        
    end loop;
    
    close _org_list;


    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_nf_parc
  ADD COLUMN id_ct_ctb_d INTEGER;

ALTER TABLE public.tb_nf_parc
  ADD COLUMN id_ct_ctb_c INTEGER;

ALTER TABLE public.tb_mov_fnc
  ADD COLUMN id_ct_ctb_d INTEGER;

ALTER TABLE public.tb_mov_fnc
  ADD COLUMN id_ct_ctb_c INTEGER;

ALTER TABLE public.tb_bx_ct
  ADD COLUMN vl_deb NUMERIC(12,4);

ALTER TABLE public.tb_bx_ct
  ADD COLUMN vl_cred NUMERIC(12,4);

ALTER TABLE public.tb_bx_ct
  ADD COLUMN dt_i DATE;

ALTER TABLE public.tb_bx_ct
  ADD COLUMN dt_f DATE;

ALTER TABLE public.tb_vnd_parc
  ADD COLUMN id_ct_ctb_d INTEGER;

ALTER TABLE public.tb_vnd_parc
  ADD COLUMN id_ct_ctb_c INTEGER;

ALTER TABLE public.tb_bx_ct_pagto
  ADD COLUMN id_ct_ctb_d INTEGER;

ALTER TABLE public.tb_bx_ct_pagto
  ADD COLUMN id_ct_ctb_c INTEGER;

CREATE TABLE public.tb_bx_ct_disp (
  id_emp INTEGER NOT NULL, 
  id_bx_ct INTEGER NOT NULL, 
  id_disp INTEGER NOT NULL, 
  vl_disp NUMERIC(12,4), 
  CONSTRAINT pk_bx_ct_disp PRIMARY KEY(id_emp, id_bx_ct, id_disp)
) ;

ALTER TABLE public.tb_bx_ct_disp
  ADD CONSTRAINT fk__bx_ct_disp__bx_ct FOREIGN KEY (id_emp, id_bx_ct)
    REFERENCES public.tb_bx_ct(id_emp, id_bx_ct)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

