CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    
    _id_est_local integer;
    _count integer;
    _aux varchar;
    _dt_hr timestamp;
begin
    _app_con := fc_app_con();

    _id_est_local := fc_id_est_local();
    _id_est := fc_id_est_con();
    
    
    select pk into _pk
    from tb_sis_uni
    where
        tab = tg_table_name;
        
    if (not found) then
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = tg_table_name
                )
        into _pk;
        
        if (not found) then
            return null;
        end if;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (tg_table_name, _pk);
    end if;
    
    _count := array_upper(_pk, 1);
    
    if (coalesce(_count, 0) <= 0) then
        return null;
    end if;
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        _val[_i] := _aux;
    end loop;
    
    _dt_hr := current_timestamp;
    
    
    insert into tb_sinc
        (id_sinc, id_est, op, tb, col_pk, val_pk, dt_hr, id_est_sinc)
    values
        (nextval('sq_sinc'), _id_est_local, substring(tg_op, 1, 1), tg_table_name, _pk, _val, _dt_hr, _id_est);
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_sis_cnt_bnc
  ADD CONSTRAINT pk_sis_cnt_bnc 
    PRIMARY KEY (id_emp, id_cnt_bnc);

