ALTER TABLE public.tb_ped
  DROP CONSTRAINT fk__ped__nf RESTRICT;

CREATE OR REPLACE FUNCTION public.fc_en_trg (
  _enabled boolean,
  _all boolean
)
RETURNS boolean AS
$body$
declare
    _cur refcursor;
    _rec record;
    _op varchar;
begin
    
    open _cur for
      select tablename
      from pg_tables
      where 
          tablename like 'tb_%';            
    
    fetch _cur into _rec;
    
    while found loop
        if (_enabled) then
            _op := 'enable';
        else
            _op := 'disable';
        end if;
        
        -- raise notice '% trigger of table % %', _op, _rec."tablename", _all;
        
        if (not _all) then
            execute 'alter table "' || _rec."tablename" || '" ' || _op || ' trigger user;';
        else
            execute 'alter table "' || _rec."tablename" || '" ' || _op || ' trigger all;';
        end if;
        
        fetch _cur into _rec;
    end loop;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_init_est (
  _id_est integer,
  _upd_id boolean
)
RETURNS boolean AS
$body$
declare
    _seq_list refcursor;
    _seq record;
    _est record;
    _id_init integer;
    _cmd varchar;
    _tab record;
    _max_id integer;
begin
    select * into _est
    from tb_est
    where
        id_est = _id_est;
        
    perform fc_en_trg(false, false);

    open _seq_list for
        select * 
        from pg_class 
        join pg_tables on
            (replace(pg_class.relname, 'sq_', 'tb_') = pg_tables.tablename and
             pg_tables.schemaname = 'public')
        where
            relkind = 'S';
            
    fetch _seq_list into _seq;
    
    while found loop
        select tb_sinc_def_item.* into _tab
        from tb_sinc_def
        join tb_sinc_def_item on
            (tb_sinc_def.id_sinc_def = tb_sinc_def_item.id_sinc_def and
             tb_sinc_def_item.env)
        where
            tb_sinc_def_item.tb = replace(_seq.relname, 'sq_', 'tb_');
        
        if (found) then
        
            _id_init := _est.seq_inc + _est.id_est;
            
            raise notice '% %', _seq.relname, _id_init;
            
            execute 
                ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') ' ||
                ' from ' || _tab.tb ||
                ' where mod(' || replace(_seq.relname, 'sq_', 'id_') || ',' || _est.seq_inc || ') = ' || _est.id_est  
                into _max_id;
            
            if (_max_id is null) then
                _max_id := _id_init;
            else
                _max_id := _max_id + _est.seq_inc;
            end if;
            
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by ' || _est.seq_inc || ' restart with ' || _max_id;
            
            -- raise notice '%', _cmd;
            
            execute _cmd;
            
            if (_upd_id is null) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = ' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' / ' || 
                    _est.seq_inc;
                
                -- raise notice '%', _cmd;
                
                execute _cmd;
            elsif (_upd_id) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = (' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' * ' || 
                    _est.seq_inc || ') + ' || _est.id_est;
                
                -- raise notice '%', _cmd;
                
                execute _cmd;
            end if;
        else 
            
            execute ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') +1 ' || ' from ' || replace(_seq.relname, 'sq_', 'tb_') into _max_id;
            
            raise notice '% %', _seq.relname, coalesce(_max_id, '1');
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by 1 restart with ' || coalesce(_max_id, '1');

            -- raise notice '%', _cmd;
            
            execute _cmd;
        
        end if;
    
        fetch _seq_list into _seq;
    end loop;
    
    update tb_est set
        local = false;
    
    update tb_est set
        local = true
    where
        id_est = _id_est;
    
    perform fc_en_trg(true, false);
    
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;
CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
    _pk varchar[];
    _log_tab boolean;
begin
    delete from tb_sis_uni
    where
        tab = _tab;
        
    select _tab not in (
        'tb_sis_uni',
        'tb_log',
        'tb_log_con',
        'tb_sinc',
        'tb_sinc_stat',
        'tb_item_estq',
        'tb_script'
    ) into _log_tab;


    if (_log_tab and _install) then
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        execute 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log after insert or update or delete ' ||
            ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';

        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
        
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = _tab
                )
        into _pk;
        
        raise notice 'Tabela: %', _tab;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (_tab, _pk);
        
        
        return true;
    else 
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    
    _id_est_local integer;
    _count integer;
    _aux varchar;
    _dt_hr timestamp;
begin
    _app_con := fc_app_con();

    _id_est_local := fc_id_est_local();
    _id_est := fc_id_est_con();
    
    
    select pk into _pk
    from tb_sis_uni
    where
        tab = tg_table_name;
        
    if (not found) then
        return null;
    end if;
    
    _count := array_upper(_pk, 1);
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        _val[_i] := _aux;
    end loop;
    
    _dt_hr := current_timestamp;
    
    
    insert into tb_sinc
        (id_sinc, id_est, op, tb, col_pk, val_pk, dt_hr, id_est_sinc)
    values
        (nextval('sq_log'), _id_est_local, substring(tg_op, 1, 1), tg_table_name, _pk, _val, _dt_hr, _id_est);
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_emp_cnf
  ADD COLUMN id_est INTEGER;

