CREATE SEQUENCE public.sq_consig
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_consig RESTART WITH 1;


CREATE TABLE public.tb_consig (
  id_emp INTEGER NOT NULL, 
  id_consig INTEGER NOT NULL, 
  dt_consig DATE, 
  dt_dev DATE, 
  id_cli INTEGER, 
  obs TEXT, 
  sit VARCHAR(5), 
  id_vndr INTEGER, 
  vl_tot NUMERIC(12,4), 
  qtd_item INTEGER
) WITHOUT OIDS;

CREATE TABLE public.tb_consig_item (
  id_emp INTEGER NOT NULL, 
  id_consig INTEGER NOT NULL, 
  id_consig_item INTEGER NOT NULL, 
  id_item INTEGER, 
  id_und_med VARCHAR(5), 
  vl_qtd NUMERIC(12,4), 
  vl_prc_unt NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  id_dep INTEGER, 
  id_grd_estq VARCHAR(20), 
  id_dep_consig INTEGER, 
  vl_qtd_dev NUMERIC(12,4)
) WITHOUT OIDS;

CREATE TABLE public.tb_nfe_inut (
  id_emp INTEGER NOT NULL, 
  id_nfe_inut INTEGER NOT NULL, 
  just VARCHAR(255), 
  ano INTEGER, 
  mod INTEGER, 
  ser INTEGER, 
  num_ini INTEGER, 
  num_fin INTEGER, 
  cd_stat INTEGER, 
  descr_stat VARCHAR(255)
) WITHOUT OIDS;


CREATE OR REPLACE FUNCTION public.fc_tr_consig_item_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'INSERT') or (tg_op = 'UPDATE') then
        if (tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd - new.vl_qtd_dev);
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_consig, new.id_grd_estq, 'E', new.vl_qtd - new.vl_qtd_dev);
        end if;
        
        if (tg_op = 'UPDATE') then
            if (new.vl_qtd <> old.vl_qtd or new.vl_qtd_dev <> old.vl_qtd_dev) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd - old.vl_qtd_dev);
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_consig, old.id_grd_estq, 'S', old.vl_qtd - old.vl_qtd_dev);
                
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd - new.vl_qtd_dev);
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_consig, new.id_grd_estq, 'E', new.vl_qtd - new.vl_qtd_dev);
            end if;
        end if;
    
        return new;
        
    elsif (tg_op = 'DELETE') then
        
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd - old.vl_qtd_dev);
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_consig, old.id_grd_estq, 'S', old.vl_qtd - old.vl_qtd_dev);
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
            
    elsif (tg_op = 'DELETE') and (fc_id_est_con() is null) then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
    
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;



ALTER TABLE public.tb_vnd
  ADD COLUMN org VARCHAR(50);

ALTER TABLE public.tb_vnd
  ADD COLUMN id_org INTEGER;

ALTER TABLE public.tb_nfe_inut
  ADD CONSTRAINT pk_nfe_inut 
    PRIMARY KEY (id_emp, id_nfe_inut);

ALTER TABLE public.tb_consig_item
  ADD CONSTRAINT pk_consig_item 
    PRIMARY KEY (id_emp, id_consig, id_consig_item);

ALTER TABLE public.tb_consig
  ADD CONSTRAINT pk_consig 
    PRIMARY KEY (id_emp, id_consig);

ALTER TABLE public.tb_nfe_inut
  ADD CONSTRAINT fk__nfe_inut__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig_item
  ADD CONSTRAINT fk__consig_item__und_med FOREIGN KEY (id_und_med)
    REFERENCES public.tb_und_med(id_und_med)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig_item
  ADD CONSTRAINT fk__consig_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig_item
  ADD CONSTRAINT fk__consig_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig_item
  ADD CONSTRAINT fk__consig_item__dep_consig FOREIGN KEY (id_emp, id_dep_consig)
    REFERENCES public.tb_dep(id_emp, id_dep)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig_item
  ADD CONSTRAINT fk__consig_item__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig_item
  ADD CONSTRAINT fk__consig_item__consig FOREIGN KEY (id_emp, id_consig)
    REFERENCES public.tb_consig(id_emp, id_consig)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig
  ADD CONSTRAINT fk__consig__vndr FOREIGN KEY (id_vndr)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig
  ADD CONSTRAINT fk__consig__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_consig
  ADD CONSTRAINT fk__consig__cli FOREIGN KEY (id_cli)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_consig_item_bf BEFORE INSERT OR UPDATE OR DELETE 
ON public.tb_consig_item FOR EACH ROW 
EXECUTE PROCEDURE public.fc_tr_consig_item_bf();

