CREATE SEQUENCE public.sq_est
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_log
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_log_con
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

DROP TRIGGER tr_vnd_af ON public.tb_vnd;

CREATE OR REPLACE FUNCTION public.fc_en_trg (
  _enabled boolean,
  _all boolean
)
RETURNS boolean AS
$body$
declare
    _cur refcursor;
    _rec record;
    _op varchar;
begin
    
    open _cur for
      select tablename
      from pg_tables
      where 
          tablename like 'tb_%';            
    
    fetch _cur into _rec;
    
    while found loop
        if (_enabled) then
            _op := 'enable';
        else
            _op := 'disable';
        end if;
        
        raise notice '% trigger of table % %', _op, _rec."tablename", _all;
        
        if (not _all) then
            execute 'alter table "' || _rec."tablename" || '" ' || _op || ' trigger user;';
        else
            execute 'alter table "' || _rec."tablename" || '" ' || _op || ' trigger all;';
        end if;
        
        fetch _cur into _rec;
    end loop;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_id_est_con (
)
RETURNS integer AS
$body$
declare
    _id_est integer;
begin
    select id_est into _id_est
    from tb_log_con
    where
        pid = pg_backend_pid();
        
    return _id_est;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_id_est_local (
)
RETURNS integer AS
$body$
declare
    _id_est integer;
begin
    select id_est into _id_est
    from tb_est
    where
        tb_est.local;
        
    return _id_est;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_init_est (
  _id_est integer,
  _upd_id boolean
)
RETURNS boolean AS
$body$
declare
    _seq_list refcursor;
    _seq record;
    _est record;
    _id_init integer;
    _cmd varchar;
begin
    select * into _est
    from tb_est
    where
        id_est = _id_est;
        
    open _seq_list for
        select * 
        from pg_class 
        where
            relkind = 'S';
            
    fetch _seq_list into _seq;
    
    perform fc_en_trg(false, false);
    
    while found loop
        if (_seq.relname not in ('sq_bairro', 'sq_logr', 'sq_munic', 'sq_log', 'sq_log_con', 'sq_est')) then
        
            _id_init := _est.seq_inc + _est.id_est;
            
            raise notice '% %', _seq.relname, _id_init;
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by ' || _est.seq_inc || ' restart with ' || _id_init;
            raise notice '%', _cmd;
            
            execute _cmd;
            
            if (_upd_id is null) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = ' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' / ' || 
                    _est.seq_inc;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            elsif (_upd_id) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = ' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' * ' || 
                    _est.seq_inc;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            end if;
        end if;
    
        fetch _seq_list into _seq;
    end loop;
    
    perform fc_en_trg(true, false);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_log_con (
  _id_est integer
)
RETURNS boolean AS
$body$
begin
    insert into tb_log_con
        (id_log_con, id_est, pid, dt_hr)
    values
        (nextval('sq_log_con'), _id_est, pg_backend_pid(), current_timestamp);

    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
begin
    --tb_emp_cnf
    
    /*
    if (_tab in ('tb_bairro', 'tb_blt', 'tb_blt_ret', 'tb_bnc', 'tb_bnc_blt', 'tb_bx_ct', 
        'tb_cfop', 'tb_ch', 'tb_cnae', 'tb_cnt_bnc', 'tb_cond_pagto', 'tb_conv',
        'tb_ct', 'tb_cx', 'tb_dep', 'tb_emis_blt', 'tb_grd_estq', 
        'tb_grp_cfop', 'tb_grp_item', 'tb_grp_trib', 'tb_grp_usr', 'tb_item',
        'tb_logr', 'tb_marca', 'tb_mnt_estq', 'tb_mod_frete', 'tb_mod_nf', 
        'tb_mov_cx', 'tb_mov_fnc', 'tb_mtv_dev_ch', 'tb_munic', 'tb_nat_op', 
        'tb_ncm', 'tb_nf', 'tb_nfe_dest', 'tb_obj_os', 'tb_op_fnc', 'tb_org_icms', 
        'tb_os', 'tb_part', 'tb_ped', 'tb_prio_os', 'tb_prod_anp', 'tb_reg_trib',
        'tb_rel', 'tb_script', 'tb_serv', 'tb_sis_grid', 'tb_sis_valid', 'tb_tp_item',
        'tb_trib_cofins', 'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis', 'tb_uf',
        'tb_und_med', 'tb_usr', 'tb_vnd')
    ) */
    if (_tab not in ('tb_log', 'tb_log_con', 'tb_item_estq')) then
    
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;

        _cmd := 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log ';
        
        if (_tab = 'tb_est') then
            _cmd := _cmd || ' after insert or delete ';
        else
            _cmd := _cmd || ' after insert or update or delete ';
        end if;
        
        _cmd := _cmd || ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';
        
        execute _cmd;
            
        return true;
        
    else 
        raise notice '%', replace(_tab, 'tb_', 'tr_');
        
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    _idx integer;
    _count integer;
    _aux varchar;
begin
    select
        array(
            select 
                cast(c.column_name as varchar)
            from information_schema.table_constraints tc
            join information_schema.constraint_column_usage as ccu using 
                (constraint_schema, constraint_name)
            join information_schema.columns as c on 
                (c.table_schema = tc.constraint_schema and 
                 tc.table_name = c.table_name and 
                 ccu.column_name = c.column_name)
            where 
                constraint_type = 'PRIMARY KEY' and
                tc.table_name = tg_table_name
            )
    into _pk;
    
    select
        array(
            select 
                pg_attribute.attname
            from pg_attribute 
            join pg_class on 
                (pg_attribute.attrelid = pg_class.oid) 
            where 
                pg_attribute.attname not in ('oid', 'tableoid', 'cmax', 'xmax', 'cmin', 'xmin', 'ctid') and 
                pg_class.relname = tg_table_name
            order by
                pg_attribute.attnum
        )
    into _col_list;
    
    
    _id_est := fc_id_est_con();
    
    _count := array_upper(_pk, 1);
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        raise notice '% %', _pk[_i], _aux;
        
        _val[_i] := _aux;
    end loop;
    
    
    insert into tb_log
        (id_log, org, op, col_pk, val_pk, id_est, dt_hr)
    values
        (nextval('sq_log'), tg_table_name, substring(tg_op, 1, 1), _pk, _val, _id_est, CURRENT_TIMESTAMP);
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_log_af (
)
RETURNS trigger AS
$body$
declare
    _est_list refcursor;
    _est record;
    _id_est_con integer;
begin
    if (new.id_est is null or new.id_est <> fc_id_est_local()) and (new.sit is null) then
        
        _id_est_con := fc_id_est_con();
        
        if (_id_est_con is null) then
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local;
        else
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local and
                    tb_est.id_est <> _id_est_con;
        end if;
        
        fetch _est_list into _est;
        
        while found loop
        
            insert into tb_log
                (id_log, org, op, col_pk, val_pk, id_est, dt_hr, sit)
            values
                (nextval('sq_log'), new.org, new.op, new.col_pk, new.val_pk, _est.id_est, new.dt_hr, 'P');
            
            fetch _est_list into _est;
        
        end loop;
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _cond_pagto record;
begin
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (new.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = new.id_cond_pagto;
            
            perform fc_gera_mov_fnc(new.id_emp, new.id_cx, new.id_usr, new.dt_vnd, cast(current_time as time), 'VENDA ' || new.nome || ' ' || _cond_pagto.descr,
                'C', new.vl_tot, 'VND', new.id_vnd);
        end if;
    elsif (tg_op = 'DELETE') then
        if (old.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = old.id_cond_pagto;

            perform fc_gera_mov_fnc(old.id_emp, old.id_cx, old.id_usr, old.dt_vnd, cast(current_time as time), 'VENDA CANCELADA '  || old.nome || ' ' || _cond_pagto.descr,
                'D', old.vl_tot, 'VND', old.id_vnd);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE TABLE public.tb_est (
  id_est INTEGER NOT NULL, 
  descr VARCHAR(150), 
  seq_inc INTEGER, 
  local BOOLEAN
) WITHOUT OIDS;

CREATE TABLE public.tb_log (
  id_log BIGINT NOT NULL, 
  org VARCHAR(255), 
  op VARCHAR(1), 
  col_pk VARCHAR[], 
  val_pk VARCHAR[], 
  id_est INTEGER, 
  dt_hr TIMESTAMP(0) WITHOUT TIME ZONE, 
  sit VARCHAR(1)
) WITHOUT OIDS;

CREATE TABLE public.tb_log_con (
  id_log_con BIGINT NOT NULL, 
  id_est INTEGER, 
  pid INTEGER, 
  dt_hr TIMESTAMP WITHOUT TIME ZONE
) WITHOUT OIDS;

CREATE OR REPLACE VIEW public.vw_tab_uni (
    tablename)
AS
 SELECT pg_tables.tablename
   FROM pg_tables
  WHERE pg_tables.schemaname = 'public'::name AND (pg_tables.tablename <> ALL (ARRAY['tb_bairro'::name, 'tb_logr'::name, 'tb_munic'::name, 'tb_log'::name, 'tb_log_con'::name]))
  ORDER BY pg_tables.tablename;

DROP FUNCTION public.tr_vnd_af();

ALTER TABLE public.tb_log_con
  ADD CONSTRAINT pk_log_con 
    PRIMARY KEY (id_log_con);

ALTER TABLE public.tb_log
  ADD CONSTRAINT pk_log 
    PRIMARY KEY (id_log);

ALTER TABLE public.tb_est
  ADD CONSTRAINT pk_est 
    PRIMARY KEY (id_est);

ALTER TABLE public.tb_log_con
  ADD CONSTRAINT fk__log_con__est FOREIGN KEY (id_est)
    REFERENCES public.tb_est(id_est)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_log
  ADD CONSTRAINT fk__log__est FOREIGN KEY (id_est)
    REFERENCES public.tb_est(id_est)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_bairro_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_bairro FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_blt_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_blt FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_blt_ret_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_blt_ret FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_bnc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_bnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_bnc_blt_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_bnc_blt FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_bx_ct_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_bx_ct FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_bx_ct__ct_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_bx_ct__ct FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_bx_ct_pagto_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_bx_ct_pagto FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_cfop_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_cfop FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_ch_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_ch FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_cnae_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_cnae FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_cnt_bnc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_cnt_bnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_cond_pagto_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_cond_pagto FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_cond_pagto_parc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_cond_pagto_parc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_conv_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_conv FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_ct_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_ct FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_cx_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_cx FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_dep_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_dep FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_emis_blt_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_emis_blt FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_emis_blt_part_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_emis_blt_part FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_emp_cnf_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_emp_cnf FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_est_log
  AFTER INSERT OR DELETE 
  ON public.tb_est FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_grd_estq_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_grd_estq FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_grp_cfop_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_grp_cfop FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_grp_cfop_nat_op_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_grp_cfop_nat_op FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_grp_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_grp_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_grp_trib_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_grp_trib FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_grp_trib_nat_op_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_grp_trib_nat_op FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_grp_usr_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_grp_usr FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_item_cd_bar_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_item_cd_bar FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_item_emp_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_item_emp FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_item_forn_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_item_forn FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_item_prc_vnd_log_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_item_prc_vnd_log FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_item_und_med_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_item_und_med FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_log_af
  AFTER INSERT 
  ON public.tb_log FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log_af();

CREATE TRIGGER tr_logr_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_logr FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_marca_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_marca FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mnt_estq_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mnt_estq FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mnt_estq_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mnt_estq_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mod_frete_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mod_frete FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mod_nf_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mod_nf FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mov_cx_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mov_cx FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mov_cx__mov_fnc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mov_cx__mov_fnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mov_cx_apur_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mov_cx_apur FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mov_fnc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mov_fnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_mtv_dev_ch_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mtv_dev_ch FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_munic_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_munic FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nat_op_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nat_op FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_ncm_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_ncm FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nf_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nf FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nf_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nf_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nf_item_grd_estq_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nf_item_grd_estq FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nf_parc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nf_parc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nfe_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nfe FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nfe_dest_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nfe_dest FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_nfe_evt_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_nfe_evt FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_obj_os_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_obj_os FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_op_fnc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_op_fnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_org_icms_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_org_icms FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_os_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_os FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_os_evt_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_os_evt FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_part_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_part FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_part_cond_pagto_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_part_cond_pagto FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_part_cred_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_part_cred FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_part_ender_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_part_ender FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_part_obs_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_part_obs FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_part_op_fnc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_part_op_fnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_part_ref_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_part_ref FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_ped_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_ped FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_ped_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_ped_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_prio_os_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_prio_os FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_prod_anp_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_prod_anp FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_reg_trib_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_reg_trib FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_rel_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_rel FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_rel_cab_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_rel_cab FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_rel_col_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_rel_col FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_rel_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_rel_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_rel_item_col_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_rel_item_col FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_rel_item_tot_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_rel_item_tot FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_rel_tot_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_rel_tot FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_script_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_script FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_serv_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_serv FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_sis_grid_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_sis_grid FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_sis_valid_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_sis_valid FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_tp_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_tp_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_trib_cofins_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_trib_cofins FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_trib_icms_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_trib_icms FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_trib_ipi_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_trib_ipi FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_trib_pis_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_trib_pis FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_uf_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_uf FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_und_med_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_und_med FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_usr_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_usr FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_usr__grp_usr_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_usr__grp_usr FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_vnd_af
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_vnd FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_vnd_af();

CREATE TRIGGER tr_vnd_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_vnd FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_vnd_item_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_vnd_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

CREATE TRIGGER tr_vnd_parc_log
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_vnd_parc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_log();

